/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv2;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.CommitMessageOperation;
import de.shadowhunt.subversion.internal.MergeOperation;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.httpv2.CreateTransactionOperation;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryImpl
extends AbstractBaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");

    RepositoryImpl(URI repository, Resource prefix, HttpClient client, HttpContext context) {
        super(repository, new ResourceMapperImpl(prefix), client, context);
    }

    @Override
    public void commit(Transaction transaction, @Nullable String message) {
        this.validateTransaction(transaction);
        LOGGER.trace("committing {} with message {}", (Object)transaction.getId(), (Object)message);
        if (transaction.isChangeSetEmpty()) {
            this.rollback(transaction);
            return;
        }
        Resource messageResource = this.config.getCommitMessageResource(transaction);
        CommitMessageOperation cmo = new CommitMessageOperation(this.repository, messageResource, message);
        cmo.execute(this.client, this.context);
        Set<Info> lockTokenInfos = this.getInfosWithLockTokens(transaction);
        Resource mergeResource = this.config.getTransactionResource(transaction);
        MergeOperation mo = new MergeOperation(this.repository, mergeResource, lockTokenInfos);
        mo.execute(this.client, this.context);
        transaction.invalidate();
    }

    @Override
    public Transaction createTransaction() {
        LOGGER.trace("creating new transaction");
        Resource resource = this.config.getCreateTransactionResource();
        CreateTransactionOperation cto = new CreateTransactionOperation(this.repository, resource);
        TransactionImpl transaction = (TransactionImpl)cto.execute(this.client, this.context);
        transaction.setRepository(this);
        return transaction;
    }

    @Override
    public Repository.ProtocolVersion getProtocolVersion() {
        return Repository.ProtocolVersion.HTTP_V2;
    }

    @Override
    protected void registerResource(Transaction transaction, Resource resource, Revision revision) {
        this.validateTransaction(transaction);
        transaction.register(resource, Transaction.Status.EXISTS);
    }

    private static class ResourceMapperImpl
    implements AbstractBaseRepository.ResourceMapper {
        private static final Resource CREATE_TRANSACTION = Resource.create("me");
        private final Resource prefix;

        public ResourceMapperImpl(Resource prefix) {
            this.prefix = prefix;
        }

        @Override
        public Resource getCommitMessageResource(Transaction transaction) {
            Resource suffix = Resource.create("/txn/" + transaction.getId());
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getCreateTransactionResource() {
            return this.prefix.append(CREATE_TRANSACTION);
        }

        @Override
        public Resource getRegisterResource(Resource resource, Revision revision) {
            throw new UnsupportedOperationException("Not supported by httpv2");
        }

        @Override
        public Resource getRegisterTransactionResource(Transaction transaction) {
            throw new UnsupportedOperationException("Not supported by httpv2");
        }

        @Override
        public Resource getTransactionResource(Transaction transaction) {
            return this.getCommitMessageResource(transaction);
        }

        @Override
        public Resource getVersionedResource(Resource resource, Revision revision) {
            assert (!Revision.HEAD.equals(revision)) : "must not be HEAD revision";
            Resource suffix = Resource.create("/rvr/" + revision + '/' + resource);
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getWorkingResource(Transaction transaction) {
            Resource suffix = Resource.create("/txr/" + transaction.getId());
            return this.prefix.append(suffix);
        }
    }
}

