/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv2;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

class CreateTransactionOperation
extends AbstractOperation<TransactionImpl> {
    private static final HttpEntity ENTITY;
    private static final String HEADER_NAME = "SVN-Txn-Name";
    private final Resource resource;

    CreateTransactionOperation(URI repository, Resource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        HttpPost request = new HttpPost(uri);
        request.setEntity(ENTITY);
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }

    @Override
    protected TransactionImpl processResponse(HttpResponse response) {
        String transactionId = response.getFirstHeader(HEADER_NAME).getValue();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return new TransactionImpl(transactionId);
    }

    static {
        ContentType contentType = ContentType.create((String)"application/vnd.svn-skel");
        ENTITY = new StringEntity("( create-txn )", contentType);
    }
}

