/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv1;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

class CreateTransactionOperation
extends AbstractOperation<TransactionImpl> {
    private final Resource resource;
    private final UUID transactionId = UUID.randomUUID();

    CreateTransactionOperation(URI repository, Resource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource, Resource.create(this.transactionId.toString()));
        return new AbstractOperation.DavTemplateRequest("MKACTIVITY", uri);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }

    @Override
    protected TransactionImpl processResponse(HttpResponse response) {
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return new TransactionImpl(this.transactionId.toString());
    }
}

