/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import org.apache.http.client.methods.HttpUriRequest;

class UnlockOperation
extends AbstractVoidOperation {
    private final boolean force;
    private final String lockToken;
    private final Resource resource;

    UnlockOperation(URI repository, Resource resource, String lockToken, boolean force) {
        super(repository);
        this.resource = resource;
        this.lockToken = lockToken;
        this.force = force;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("UNLOCK", uri);
        request.addHeader("Lock-Token", '<' + this.lockToken + '>');
        if (this.force) {
            request.addHeader("X-SVN-Options", "lock-break");
        }
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 204 == statusCode;
    }
}

