/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.Resolve;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

class ResolveOperation
extends AbstractOperation<Resource> {
    private final AbstractBaseRepository.ResourceMapper config;
    private final Revision expected;
    private final Resource resource;
    private final Revision revision;

    ResolveOperation(URI repository, Resource resource, Revision revision, Revision expected, AbstractBaseRepository.ResourceMapper config) {
        super(repository);
        this.resource = resource;
        this.revision = revision;
        this.expected = expected;
        this.config = config;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("REPORT", uri);
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<get-locations xmlns=\"svn:\"><path/><peg-revision>");
        sb.append(this.revision);
        sb.append("</peg-revision><location-revision>");
        sb.append(this.expected);
        sb.append("</location-revision></get-locations>");
        request.setEntity((HttpEntity)new StringEntity(sb.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode || 404 == statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    protected Resource processResponse(HttpResponse response) {
        int statusCode = ResolveOperation.getStatusCode(response);
        if (statusCode == 404) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return null;
        }
        InputStream in = ResolveOperation.getContent(response);
        try {
            Resolve resolve = Resolve.read(in);
            Resource resource = this.config.getVersionedResource(resolve.getResource(), this.expected);
            return resource;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

