/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.BasicHandler;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class Resolve {
    private Resource resource = null;
    private Revision revision = null;

    Resolve() {
    }

    static Resolve read(InputStream inputStream) {
        Resolve resolve;
        try {
            SAXParser saxParser = BasicHandler.FACTORY.newSAXParser();
            ResolveHandler handler = new ResolveHandler();
            saxParser.parse(inputStream, (DefaultHandler)handler);
            resolve = handler.getEntry();
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        if (resolve == null) {
            throw new SubversionException("Invalid server response: could not parse response");
        }
        return resolve;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolve other = (Resolve)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public Resource getResource() {
        return this.resource;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    void setResource(Resource resource) {
        this.resource = resource;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resolve [resource=");
        builder.append(this.resource);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }

    private static class ResolveHandler
    extends BasicHandler {
        private Resolve entry = null;

        ResolveHandler() {
        }

        @CheckForNull
        public Resolve getEntry() {
            return this.entry;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.clearText();
            String name = this.getNameFromQName(qName);
            if ("location".equals(name)) {
                this.entry = new Resolve();
                String version = attributes.getValue("rev");
                this.entry.setRevision(Revision.create(Integer.parseInt(version)));
                String path = attributes.getValue("path");
                this.entry.setResource(Resource.create(path));
            }
        }
    }
}

