/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.InfoOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

public class RepositoryCache {
    private final Map<Key, Info> cache = new HashMap<Key, Info>();
    private Revision headRevision = null;
    private AbstractBaseRepository repository = null;

    public RepositoryCache() {
    }

    public RepositoryCache(AbstractBaseRepository repository) {
        this.repository = repository;
    }

    public final void clear() {
        this.cache.clear();
        this.headRevision = null;
    }

    public final boolean contains(Resource resource, Revision revision) {
        return this.get(resource, revision) != null;
    }

    private Revision determineHeadRevision() {
        if (this.headRevision != null) {
            return this.headRevision;
        }
        Resource resolved = this.repository.resolve(this, Resource.ROOT, Revision.HEAD, false);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + Resource.ROOT + '@' + Revision.HEAD);
        }
        InfoOperation operation = new InfoOperation(this.repository.getBaseUri(), resolved, this.repository.getVersionParser());
        Info info = (Info)operation.execute(this.repository.client, this.repository.context);
        this.headRevision = info.getRevision();
        this.put(info);
        return this.headRevision;
    }

    @CheckForNull
    public final Info get(Resource resource, Revision revision) {
        Revision concreteRevision = revision;
        if (Revision.HEAD.equals(revision)) {
            concreteRevision = this.getConcreteRevision(revision);
        }
        return this.cache.get(new Key(resource, concreteRevision));
    }

    public final Revision getConcreteRevision(Revision revision) {
        if (Revision.HEAD.equals(revision)) {
            return this.determineHeadRevision();
        }
        return revision;
    }

    public AbstractBaseRepository getRepository() {
        return this.repository;
    }

    public final boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public final void put(Info info) {
        this.cache.put(new Key(info.getResource(), info.getRevision()), info);
    }

    public final void putAll(Collection<Info> collection) {
        for (Info info : collection) {
            this.put(info);
        }
    }

    public void setRepository(AbstractBaseRepository repository) {
        this.repository = repository;
    }

    @CheckForNull
    public Transaction.Status status(Resource resource) {
        return null;
    }

    private static final class Key {
        private final Resource resource;
        private final Revision revision;

        Key(Resource resource, Revision revision) {
            this.resource = resource;
            this.revision = revision;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (!this.resource.equals(key.resource)) {
                return false;
            }
            return this.revision.equals(key.revision);
        }

        public int hashCode() {
            int result = this.resource.hashCode();
            result = 31 * result + this.revision.hashCode();
            return result;
        }
    }
}

