/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class PropertiesSetOperation
extends AbstractVoidOperation {
    private final Info info;
    private final ResourceProperty[] properties;
    private final Resource resource;

    PropertiesSetOperation(URI repository, Resource resource, @Nullable Info info, ResourceProperty[] properties) {
        super(repository);
        this.resource = resource;
        this.info = info;
        this.properties = Arrays.copyOf(properties, properties.length);
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPPATCH", uri);
        if (this.info != null && this.info.isLocked()) {
            URI lockTarget = URIUtils.createURI(this.repository, this.info.getResource());
            request.addHeader("If", '<' + lockTarget.toASCIIString() + "> (<" + this.info.getLockToken() + ">)");
        }
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<propertyupdate xmlns=\"DAV:\" xmlns:C=\"http://subversion.tigris.org/xmlns/custom/\" xmlns:S=\"http://subversion.tigris.org/xmlns/svn/\" xmlns:V=\"http://subversion.tigris.org/xmlns/dav/\"><set><prop>");
        for (ResourceProperty property : this.properties) {
            String prefix = property.getType().getPrefix();
            String name = property.getName();
            sb.append('<');
            sb.append(prefix);
            sb.append(name);
            sb.append('>');
            sb.append(StringEscapeUtils.escapeXml10((String)property.getValue()));
            sb.append("</");
            sb.append(prefix);
            sb.append(name);
            sb.append('>');
        }
        sb.append("</prop></set></propertyupdate>");
        request.setEntity((HttpEntity)new StringEntity(sb.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }
}

