/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class PropertiesDeleteOperation
extends AbstractVoidOperation {
    private final Info info;
    private final ResourceProperty[] properties;
    private final Resource resource;

    PropertiesDeleteOperation(URI repository, Resource resource, @Nullable Info info, ResourceProperty[] properties) {
        super(repository);
        this.resource = resource;
        this.info = info;
        this.properties = Arrays.copyOf(properties, properties.length);
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPPATCH", uri);
        if (this.info != null && this.info.isLocked()) {
            URI lockTarget = URIUtils.createURI(this.repository, this.info.getResource());
            request.addHeader("If", '<' + lockTarget.toASCIIString() + "> (<" + this.info.getLockToken() + ">)");
        }
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<propertyupdate xmlns=\"DAV:\" xmlns:C=\"http://subversion.tigris.org/xmlns/custom/\" xmlns:S=\"http://subversion.tigris.org/xmlns/svn/\" xmlns:V=\"http://subversion.tigris.org/xmlns/dav/\"><remove><prop>");
        for (ResourceProperty property : this.properties) {
            sb.append('<');
            sb.append(property.getType().getPrefix());
            sb.append(property.getName());
            sb.append("/>");
        }
        sb.append("</prop></remove></propertyupdate>");
        request.setEntity((HttpEntity)new StringEntity(sb.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }
}

