/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.Prefix;
import de.shadowhunt.subversion.internal.RepositoryLocator;
import java.io.InputStream;
import java.net.URI;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

class ProbeServerOperation
extends AbstractOperation<Repository> {
    private static Repository.ProtocolVersion determineVersion(HttpResponse response) {
        for (Header header : response.getAllHeaders()) {
            if (!header.getName().startsWith("SVN")) continue;
            return Repository.ProtocolVersion.HTTP_V2;
        }
        return Repository.ProtocolVersion.HTTP_V1;
    }

    ProbeServerOperation(URI repository) {
        super(repository);
    }

    @Override
    protected HttpUriRequest createRequest() {
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("OPTIONS", this.repository);
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<options xmlns=\"DAV:\"><activity-collection-set/></options>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository execute(HttpClient client, HttpContext context) {
        Resource prefix;
        HttpUriRequest request = this.createRequest();
        HttpResponse response = this.executeRequest(request, client, context);
        this.check(response, request.getURI());
        Repository.ProtocolVersion version = ProbeServerOperation.determineVersion(response);
        InputStream in = ProbeServerOperation.getContent(response);
        try {
            prefix = Prefix.read(in, version);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        for (RepositoryLocator repositoryLocator : ServiceLoader.load(RepositoryLocator.class)) {
            if (!repositoryLocator.isSupported(version)) continue;
            return repositoryLocator.create(this.repository, prefix, client, context);
        }
        throw new SubversionException("Could not find suitable repository for " + this.repository);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected Repository processResponse(HttpResponse response) {
        throw new UnsupportedOperationException();
    }
}

