/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.BasicHandler;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class Prefix {
    private static final Pattern PATH_PATTERN = Pattern.compile("/");

    static Resource read(InputStream inputStream, Repository.ProtocolVersion version) {
        Resource prefix;
        try {
            SAXParser saxParser = BasicHandler.FACTORY.newSAXParser();
            PrefixHandler handler = new PrefixHandler(version);
            saxParser.parse(inputStream, (DefaultHandler)handler);
            prefix = handler.getPrefix();
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        if (prefix == null) {
            throw new SubversionException("Invalid server response: could not parse response");
        }
        return prefix;
    }

    private Prefix() {
    }

    private static class PrefixHandler
    extends BasicHandler {
        private Resource prefix = null;
        private final Repository.ProtocolVersion version;

        PrefixHandler(Repository.ProtocolVersion version) {
            this.version = version;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String name = this.getNameFromQName(qName);
            if ((Repository.ProtocolVersion.HTTP_V1 == this.version || Repository.ProtocolVersion.HTTP_V2 == this.version) && "href".equals(name)) {
                String text = this.getText();
                String[] segments = PATH_PATTERN.split(text);
                this.prefix = Resource.create(segments[segments.length - 2]);
                return;
            }
        }

        @CheckForNull
        Resource getPrefix() {
            return this.prefix;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.clearText();
        }
    }
}

