/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import java.net.URI;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class MergeOperation
extends AbstractVoidOperation {
    private final Set<Info> infos;
    private final Resource resource;

    public MergeOperation(URI repository, Resource resource, Set<Info> infos) {
        super(repository);
        this.resource = resource;
        this.infos = infos;
    }

    @Override
    protected HttpUriRequest createRequest() {
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("MERGE", this.repository);
        request.addHeader("X-SVN-Options", "release-locks");
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<merge xmlns=\"DAV:\"><source><href>");
        body.append(StringEscapeUtils.escapeXml10((String)(this.repository.getPath() + this.resource.getValue())));
        body.append("</href></source><no-auto-merge/><no-checkout/><prop><checked-in/><version-name/><resourcetype/><creationdate/><creator-displayname/></prop>");
        if (!this.infos.isEmpty()) {
            body.append("<S:lock-token-list xmlns:S=\"svn:\">");
            for (Info info : this.infos) {
                String lockToken = info.getLockToken();
                assert (lockToken != null) : "must not be null";
                body.append("<S:lock><S:lock-path>");
                Resource plain = info.getResource();
                body.append(StringEscapeUtils.escapeXml10((String)plain.getValueWithoutLeadingSeparator()));
                body.append("</S:lock-path>");
                body.append("<S:lock-token>");
                body.append(lockToken);
                body.append("</S:lock-token></S:lock>");
            }
            body.append("</S:lock-token-list>");
        }
        body.append("</merge>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }
}

