/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.LogImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class LogOperation
extends AbstractOperation<List<Log>> {
    private final Revision end;
    private final int limit;
    private final Resource resource;
    private final Revision start;

    public LogOperation(URI repository, Resource resource, Revision start, Revision end, int limit) {
        super(repository);
        this.resource = resource;
        this.start = start;
        this.end = end;
        this.limit = limit;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("REPORT", uri);
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<log-report xmlns=\"svn:\"><start-revision>");
        body.append(this.start);
        body.append("</start-revision><end-revision>");
        body.append(this.end);
        body.append("</end-revision>");
        if (this.limit > 0) {
            body.append("<limit>");
            body.append(this.limit);
            body.append("</limit>");
        }
        body.append("<discover-changed-paths/><encode-binary-props/><all-revprops/><path/></log-report>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Log> processResponse(HttpResponse response) {
        InputStream in = LogOperation.getContent(response);
        try {
            List<Log> logs;
            List<Log> list = logs = LogImpl.read(in);
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

