/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.BasicHandler;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class LogImpl
implements Log {
    private String author = null;
    private Date date = null;
    private String message = "";
    private Revision revision = null;

    static List<LogImpl> read(InputStream in) {
        try {
            SAXParser saxParser = BasicHandler.FACTORY.newSAXParser();
            SubversionLogHandler handler = new SubversionLogHandler();
            saxParser.parse(in, (DefaultHandler)handler);
            return handler.getLogs();
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    LogImpl() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogImpl other = (LogImpl)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getDate() {
        return new Date(this.date.getTime());
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    void setAuthor(String author) {
        this.author = author;
    }

    void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Log [author=");
        builder.append(this.author);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }

    private static class SubversionLogHandler
    extends BasicHandler {
        private static final TimeZone ZULU = TimeZone.getTimeZone("ZULU");
        private LogImpl current = null;
        private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
        private final List<LogImpl> logs = new ArrayList<LogImpl>();

        SubversionLogHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String name = this.getNameFromQName(qName);
            if ("log-item".equals(name)) {
                this.logs.add(this.current);
                this.current = null;
                return;
            }
            if (this.current == null) {
                return;
            }
            if ("comment".equals(name)) {
                this.current.setMessage(this.getText());
                return;
            }
            if ("creator-displayname".equals(name)) {
                this.current.setAuthor(this.getText());
                return;
            }
            if ("date".equals(name)) {
                String time = this.getText();
                if ('Z' != time.charAt(time.length() - 1)) {
                    throw new SAXException("Invalid server response: date is not in Zulu timezone");
                }
                int index = time.indexOf(46);
                if (index > 0) {
                    time = time.substring(0, index + 4);
                }
                try {
                    this.format.setTimeZone(ZULU);
                    Date date = this.format.parse(time);
                    this.current.setDate(date);
                }
                catch (ParseException e) {
                    throw new SAXException("Invalid server response: date has unexpected format", e);
                }
                return;
            }
            if ("version-name".equals(name)) {
                int revision = Integer.parseInt(this.getText());
                this.current.setRevision(Revision.create(revision));
                return;
            }
        }

        List<LogImpl> getLogs() {
            return this.logs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.clearText();
            String name = this.getNameFromQName(qName);
            if ("log-item".equals(name)) {
                this.current = new LogImpl();
                return;
            }
        }
    }
}

