/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class LockOperation
extends AbstractVoidOperation {
    private final Resource resource;
    private final boolean steal;

    public LockOperation(URI repository, Resource resource, boolean steal) {
        super(repository);
        this.resource = resource;
        this.steal = steal;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("LOCK", uri);
        if (this.steal) {
            request.addHeader("X-SVN-Options", "lock-steal");
        }
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<lockinfo xmlns=\"DAV:\"><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockinfo>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }
}

