/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.InfoImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.VersionParser;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class InfoOperation
extends AbstractOperation<Info> {
    private static final String LOCK_OWNER_HEADER = "X-SVN-Lock-Owner";
    private final VersionParser parser;
    private final Resource resource;

    public InfoOperation(URI repository, Resource resource, VersionParser parser) {
        super(repository);
        this.resource = resource;
        this.parser = parser;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPFIND", uri);
        request.addHeader("Depth", Depth.EMPTY.value);
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<propfind xmlns=\"DAV:\"><allprop/></propfind>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Info processResponse(HttpResponse response) {
        InputStream in = InfoOperation.getContent(response);
        try {
            InfoImpl info = InfoImpl.read(in, this.parser);
            if (info.isLocked()) {
                Header header = response.getFirstHeader(LOCK_OWNER_HEADER);
                info.setLockOwner(header.getValue());
            }
            InfoImpl infoImpl = info;
            return infoImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

