/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.BasicHandler;
import de.shadowhunt.subversion.internal.VersionParser;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class InfoImpl
implements Info {
    private static final ResourceProperty[] EMPTY = new ResourceProperty[0];
    private boolean directory = false;
    private String lockOwner = null;
    private String lockToken = null;
    private String md5 = null;
    private ResourceProperty[] properties = EMPTY;
    private UUID repositoryId = null;
    private Resource resource = null;
    private Revision revision = null;

    static InfoImpl read(InputStream in, VersionParser parser) {
        SortedSet<InfoImpl> infos = InfoImpl.readAll(in, parser);
        if (infos.isEmpty()) {
            throw new SubversionException("Invalid server response: expected content is missing");
        }
        return infos.first();
    }

    static SortedSet<InfoImpl> readAll(InputStream in, VersionParser parser) {
        try {
            SAXParser saxParser = BasicHandler.FACTORY.newSAXParser();
            SubversionInfoHandler handler = new SubversionInfoHandler(parser);
            saxParser.parse(in, (DefaultHandler)handler);
            return handler.getInfos();
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    InfoImpl() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoImpl other = (InfoImpl)obj;
        if (this.directory != other.directory) {
            return false;
        }
        if (this.lockOwner == null ? other.lockOwner != null : !this.lockOwner.equals(other.lockOwner)) {
            return false;
        }
        if (this.lockToken == null ? other.lockToken != null : !this.lockToken.equals(other.lockToken)) {
            return false;
        }
        if (this.md5 == null ? other.md5 != null : !this.md5.equals(other.md5)) {
            return false;
        }
        if (this.repositoryId == null ? other.repositoryId != null : !this.repositoryId.equals(other.repositoryId)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public String getLockToken() {
        return this.lockToken;
    }

    @Override
    public String getMd5() {
        return this.md5;
    }

    @Override
    public ResourceProperty[] getProperties() {
        return Arrays.copyOf(this.properties, this.properties.length);
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directory ? 1231 : 1237);
        result = 31 * result + (this.lockOwner == null ? 0 : this.lockOwner.hashCode());
        result = 31 * result + (this.lockToken == null ? 0 : this.lockToken.hashCode());
        result = 31 * result + (this.md5 == null ? 0 : this.md5.hashCode());
        result = 31 * result + (this.repositoryId == null ? 0 : this.repositoryId.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isFile() {
        return !this.directory;
    }

    @Override
    public boolean isLocked() {
        return this.lockToken != null;
    }

    void setDirectory(boolean directory) {
        this.directory = directory;
    }

    void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    void setMd5(String md5) {
        this.md5 = md5;
    }

    void setProperties(@Nullable ResourceProperty[] properties) {
        this.properties = properties == null || properties.length == 0 ? EMPTY : Arrays.copyOf(properties, properties.length);
    }

    void setRepositoryId(UUID repositoryId) {
        this.repositoryId = repositoryId;
    }

    void setResource(Resource resource) {
        this.resource = resource;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Info [directory=");
        builder.append(this.directory);
        builder.append(", lockOwner=");
        builder.append(this.lockOwner);
        builder.append(", lockToken=");
        builder.append(this.lockToken);
        builder.append(", md5=");
        builder.append(this.md5);
        builder.append(", properties=");
        builder.append(Arrays.toString(this.properties));
        builder.append(", repositoryId=");
        builder.append(this.repositoryId);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }

    private static class SubversionInfoHandler
    extends BasicHandler {
        private boolean checkedin = false;
        private InfoImpl current = null;
        private final SortedSet<InfoImpl> infos = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        private boolean locktoken = false;
        private final VersionParser parser;
        private Set<ResourceProperty> properties = null;
        private boolean resourceType = false;

        SubversionInfoHandler(VersionParser parser) {
            this.parser = parser;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String name = this.getNameFromQName(qName);
            if (this.current == null) {
                return;
            }
            if ("response".equals(name)) {
                if (this.current.getResource() != null) {
                    this.current.setProperties(this.properties.toArray(new ResourceProperty[this.properties.size()]));
                    this.infos.add(this.current);
                }
                this.properties = null;
                this.current = null;
                return;
            }
            if ("baseline-relative-path".equals(name)) {
                Resource resource = Resource.create(this.getText());
                this.current.setResource(resource);
                return;
            }
            if (this.resourceType && "collection".equals(name)) {
                this.current.setDirectory(true);
                this.resourceType = false;
                return;
            }
            if (this.checkedin && "href".equals(name)) {
                String text = this.getText();
                Revision revision = this.parser.getRevisionFromPath(text);
                this.current.setRevision(revision);
                this.checkedin = false;
                return;
            }
            if (this.locktoken && "href".equals(name)) {
                this.current.setLockToken(this.getText());
                this.locktoken = false;
                return;
            }
            if ("md5-checksum".equals(name)) {
                this.current.setMd5(this.getText());
                return;
            }
            if ("repository-uuid".equals(name)) {
                this.current.setRepositoryId(UUID.fromString(this.getText()));
                return;
            }
            String namespace = this.getNamespaceFromQName(qName);
            if ("C".equals(namespace)) {
                ResourceProperty property = new ResourceProperty(ResourceProperty.Type.CUSTOM, name, this.getText());
                this.properties.add(property);
                return;
            }
            if ("S".equals(namespace)) {
                ResourceProperty property = new ResourceProperty(ResourceProperty.Type.SVN, name, this.getText());
                this.properties.add(property);
                return;
            }
        }

        SortedSet<InfoImpl> getInfos() {
            return this.infos;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.clearText();
            String name = this.getNameFromQName(qName);
            if ("checked-in".equals(name)) {
                this.checkedin = true;
                return;
            }
            if ("response".equals(name)) {
                this.current = new InfoImpl();
                this.locktoken = false;
                this.resourceType = false;
                this.properties = new TreeSet<ResourceProperty>(ResourceProperty.TYPE_NAME_COMPARATOR);
                return;
            }
            if ("locktoken".equals(name)) {
                this.locktoken = true;
                return;
            }
            if ("resourcetype".equals(name)) {
                this.resourceType = true;
                return;
            }
        }
    }
}

