/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

class DownloadOperation
extends AbstractOperation<InputStream> {
    private final Resource resource;

    DownloadOperation(URI repository, Resource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        return new HttpGet(uri);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected InputStream processResponse(HttpResponse response) {
        return DownloadOperation.getContent(response);
    }
}

