/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpUriRequest;

class CopyOperation
extends AbstractVoidOperation {
    private final Info info;
    private final Resource source;
    private final Resource target;

    public CopyOperation(URI repository, Resource source, Resource target, @Nullable Info info) {
        super(repository);
        this.source = source;
        this.target = target;
        this.info = info;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI sourceUri = URIUtils.createURI(this.repository, this.source);
        URI targetUri = URIUtils.createURI(this.repository, this.target);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("COPY", sourceUri);
        request.addHeader("Destination", targetUri.toASCIIString());
        request.addHeader("Depth", Depth.INFINITY.value);
        request.addHeader("Override", "T");
        if (this.info != null && this.info.isLocked()) {
            URI lockTarget = URIUtils.createURI(this.repository, this.info.getResource());
            request.addHeader("If", '<' + lockTarget.toASCIIString() + "> (<" + this.info.getLockToken() + ">)");
        }
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode || 204 == statusCode;
    }
}

