/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class CommitMessageOperation
extends AbstractVoidOperation {
    private final String message;
    private final Resource resource;

    public CommitMessageOperation(URI repository, Resource resource, @Nullable String message) {
        super(repository);
        this.resource = resource;
        this.message = message;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPPATCH", uri);
        StringBuilder body = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<propertyupdate xmlns=\"DAV:\" xmlns:S=\"http://subversion.tigris.org/xmlns/svn/\"><set><prop><S:log>");
        if (StringUtils.isNotEmpty((CharSequence)this.message)) {
            body.append(StringEscapeUtils.escapeXml10((String)this.message));
        }
        body.append("</S:log></prop></set></propertyupdate>");
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }
}

