/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.SubversionException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public abstract class AbstractOperation<T> {
    protected static final ContentType CONTENT_TYPE_XML = ContentType.create((String)"text/xml", (String)"UTF-8");
    protected static final String XML_PREAMBLE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    protected final URI repository;

    static InputStream getContent(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new SubversionException("Invalid server response: entity is missing");
        }
        try {
            return entity.getContent();
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: content stream is missing", e);
        }
    }

    static int getStatusCode(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        return statusLine == null ? 0 : statusLine.getStatusCode();
    }

    protected AbstractOperation(URI repository) {
        this.repository = repository;
    }

    protected void check(HttpResponse response, URI requestUri) {
        String message;
        int statusCode = AbstractOperation.getStatusCode(response);
        if (this.isExpectedStatusCode(statusCode)) {
            return;
        }
        switch (statusCode) {
            case 403: {
                message = "Insufficient permissions to execute operation on url:" + requestUri;
                break;
            }
            case 404: {
                message = "Requested url: " + requestUri + " could not be found";
                break;
            }
            case 423: {
                message = "Requested url: " + requestUri + " is locked by another user";
                break;
            }
            default: {
                message = "Unexpected server response";
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        throw new SubversionException(message, statusCode);
    }

    final void clearRedirects(HttpContext context) {
        context.removeAttribute("http.protocol.redirect-locations");
    }

    protected abstract HttpUriRequest createRequest();

    public T execute(HttpClient client, HttpContext context) {
        HttpUriRequest request = this.createRequest();
        HttpResponse response = this.executeRequest(request, client, context);
        this.check(response, request.getURI());
        return this.processResponse(response);
    }

    final HttpResponse executeRequest(HttpUriRequest request, HttpClient client, HttpContext context) {
        this.clearRedirects(context);
        try {
            return client.execute(request, context);
        }
        catch (Exception e) {
            throw new SubversionException("Could not execute request (" + request + ')', e);
        }
    }

    protected abstract boolean isExpectedStatusCode(int var1);

    protected abstract T processResponse(HttpResponse var1);

    protected static final class DavTemplateRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        public DavTemplateRequest(String method, URI uri) {
            this.method = method;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.method;
        }
    }
}

