/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.internal.CopyOperation;
import de.shadowhunt.subversion.internal.CreateFolderOperation;
import de.shadowhunt.subversion.internal.DeleteOperation;
import de.shadowhunt.subversion.internal.DownloadOperation;
import de.shadowhunt.subversion.internal.ExistsOperation;
import de.shadowhunt.subversion.internal.InfoOperation;
import de.shadowhunt.subversion.internal.ListOperation;
import de.shadowhunt.subversion.internal.LockOperation;
import de.shadowhunt.subversion.internal.LogOperation;
import de.shadowhunt.subversion.internal.PropertiesDeleteOperation;
import de.shadowhunt.subversion.internal.PropertiesSetOperation;
import de.shadowhunt.subversion.internal.RepositoryCache;
import de.shadowhunt.subversion.internal.ResolveOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.UnlockOperation;
import de.shadowhunt.subversion.internal.UploadOperation;
import de.shadowhunt.subversion.internal.VersionParser;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");
    protected final HttpClient client;
    protected final ResourceMapper config;
    protected final HttpContext context;
    private final VersionParser parser;
    protected final URI repository;
    private final UUID repositoryId;

    private static UUID determineRepositoryId(URI repository, VersionParser parser, HttpClient client, HttpContext context) {
        InfoOperation operation = new InfoOperation(repository, Resource.ROOT, parser);
        Info info = (Info)operation.execute(client, context);
        return info.getRepositoryId();
    }

    protected static RepositoryCache fromTransaction(Transaction transaction) {
        if (transaction instanceof RepositoryCache) {
            return (RepositoryCache)((Object)transaction);
        }
        throw new IllegalArgumentException("Can not get repository cache for " + transaction);
    }

    protected AbstractBaseRepository(URI repository, ResourceMapper config, HttpClient client, HttpContext context) {
        Validate.notNull((Object)repository, (String)"repository must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"config must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        this.repository = URIUtils.createURI(repository, new Resource[0]);
        this.config = config;
        this.client = client;
        this.context = context;
        this.parser = new VersionParser(repository.getPath());
        this.repositoryId = AbstractBaseRepository.determineRepositoryId(repository, this.parser, client, context);
    }

    @Override
    public void add(Transaction transaction, Resource resource, boolean parents, InputStream content) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"content must not be null", (Object[])new Object[0]);
        LOGGER.trace("adding resource {} during transaction {} (parents: {})", new Object[]{resource, transaction.getId(), parents});
        if (parents) {
            this.mkdir(transaction, resource.getParent(), parents);
        }
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info info = this.info0(cache, resource, Revision.HEAD, true);
        Resource uploadResource = this.config.getWorkingResource(transaction).append(resource);
        UploadOperation operation = new UploadOperation(this.repository, uploadResource, info, content);
        operation.execute(this.client, this.context);
        if (info == null) {
            transaction.register(resource, Transaction.Status.ADDED);
        } else {
            transaction.register(resource, Transaction.Status.MODIFIED);
        }
    }

    @Override
    public void copy(Transaction transaction, Resource sourceResource, Revision sourceRevision, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)sourceResource, (String)"sourceResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)sourceRevision, (String)"sourceRevision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        LOGGER.trace("coping resource from {}@{} to {} during transaction {} (parents: {})", new Object[]{sourceResource, sourceRevision, targetResource, transaction.getId(), parents});
        if (parents) {
            this.createFolder(transaction, targetResource.getParent(), Revision.HEAD, parents);
        } else {
            this.registerResource(transaction, targetResource.getParent(), Revision.HEAD);
        }
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info sourceInfo = this.info0(cache, sourceResource, sourceRevision, true);
        if (sourceInfo == null) {
            throw new SubversionException("Can't resolve: " + sourceResource + '@' + sourceRevision);
        }
        Info targetInfo = this.info0(cache, targetResource, Revision.HEAD, true);
        Resource source = this.config.getVersionedResource(sourceInfo.getResource(), sourceInfo.getRevision());
        Resource target = this.config.getWorkingResource(transaction).append(targetResource);
        CopyOperation operation = new CopyOperation(this.repository, source, target, targetInfo);
        operation.execute(this.client, this.context);
        if (targetInfo == null) {
            transaction.register(targetResource, Transaction.Status.ADDED);
        } else {
            transaction.register(targetResource, Transaction.Status.MODIFIED);
        }
    }

    private void createFolder(Transaction transaction, Resource resource, Revision revision, boolean parents) {
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info info = this.info0(cache, resource, revision, true);
        if (parents && info == null && !Resource.ROOT.equals(resource)) {
            this.createFolder(transaction, resource.getParent(), revision, parents);
        }
        if (info == null) {
            Resource folder = this.config.getWorkingResource(transaction).append(resource);
            CreateFolderOperation operation = new CreateFolderOperation(this.repository, folder);
            operation.execute(this.client, this.context);
            transaction.register(resource, Transaction.Status.ADDED);
        } else {
            if (info.isFile()) {
                throw new SubversionException("Can not create folder. File with same name already exists: " + resource);
            }
            Transaction.Status status = transaction.getChangeSet().get(resource);
            if (status == null) {
                this.registerResource(transaction, resource, revision);
            }
        }
        Resource current = resource.getParent();
        while (!Resource.ROOT.equals(current) && transaction.register(current, Transaction.Status.EXISTS)) {
            current = current.getParent();
        }
    }

    @Override
    public void delete(Transaction transaction, Resource resource) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("deleting resource {} during transaction {}", (Object)resource, (Object)transaction.getId());
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info info = this.info0(cache, resource, Revision.HEAD, true);
        DeleteOperation operation = new DeleteOperation(this.repository, this.config.getWorkingResource(transaction).append(resource), info);
        operation.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.DELETED);
    }

    @Override
    public final InputStream download(Resource resource, Revision revision) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        LOGGER.trace("downloading resource {}@{}", (Object)resource, (Object)revision);
        return this.download0(new RepositoryCache(this), resource, revision);
    }

    private InputStream download0(RepositoryCache cache, Resource resource, Revision revision) {
        Resource resolved = this.resolve(cache, resource, revision, true);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        DownloadOperation operation = new DownloadOperation(this.repository, resolved);
        return (InputStream)operation.execute(this.client, this.context);
    }

    @Override
    public final URI downloadURI(Resource resource, Revision revision) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        LOGGER.trace("creating download uri for resource {}@{}", (Object)resource, (Object)revision);
        return this.downloadURI0(new RepositoryCache(this), resource, revision);
    }

    private URI downloadURI0(RepositoryCache cache, Resource resource, Revision revision) {
        Resource resolved = this.resolve(cache, resource, revision, true);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        return URIUtils.createURI(this.repository, resolved);
    }

    @Override
    public final boolean exists(Resource resource, Revision revision) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        LOGGER.trace("checking existence for resource {}@{}", (Object)resource, (Object)revision);
        return this.exists0(new RepositoryCache(this), resource, revision);
    }

    private boolean exists0(RepositoryCache cache, Resource resource, Revision revision) {
        Info info;
        if (Revision.HEAD.equals(revision)) {
            Transaction.Status status = cache.status(resource);
            if (status == Transaction.Status.ADDED || status == Transaction.Status.MODIFIED) {
                return true;
            }
            if (status == Transaction.Status.DELETED) {
                return false;
            }
        }
        if ((info = cache.get(resource, revision)) != null) {
            return true;
        }
        Resource resolved = this.resolve(cache, resource, revision, false);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        ExistsOperation operation = new ExistsOperation(this.repository, resolved);
        return (Boolean)operation.execute(this.client, this.context);
    }

    @Override
    public final URI getBaseUri() {
        return URIUtils.createURI(this.repository, new Resource[0]);
    }

    protected Set<Info> getInfosWithLockTokens(Transaction transaction) {
        this.validateTransaction(transaction);
        Map<Resource, Transaction.Status> changeSet = transaction.getChangeSet();
        if (changeSet.isEmpty()) {
            return Collections.emptySet();
        }
        RepositoryCache repositoryCache = AbstractBaseRepository.fromTransaction(transaction);
        TreeSet<Info> infos = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        for (Map.Entry<Resource, Transaction.Status> entry : changeSet.entrySet()) {
            Resource resource;
            Info info;
            Transaction.Status status = entry.getValue();
            if (Transaction.Status.EXISTS == status || Transaction.Status.ADDED == status || (info = this.info0(repositoryCache, resource = entry.getKey(), Revision.HEAD, false)) == null || !info.isLocked()) continue;
            infos.add(info);
        }
        return infos;
    }

    @Override
    public final UUID getRepositoryId() {
        return this.repositoryId;
    }

    protected VersionParser getVersionParser() {
        return this.parser;
    }

    @Override
    public final Info info(Resource resource, Revision revision) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        LOGGER.trace("retrieving info for resource {}@{}", (Object)resource, (Object)revision);
        Info info = this.info0(new RepositoryCache(this), resource, revision, true);
        if (info == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        return info;
    }

    @CheckForNull
    private Info info0(RepositoryCache cache, Resource resource, Revision revision, boolean resolve) {
        Info info = cache.get(resource, revision);
        if (info != null) {
            return info;
        }
        Resource resolved = this.resolve(cache, resource, revision, resolve);
        if (resolved == null) {
            return null;
        }
        InfoOperation operation = new InfoOperation(this.repository, resolved, this.parser);
        info = (Info)operation.execute(this.client, this.context);
        cache.put(info);
        return info;
    }

    @Override
    public final Set<Info> list(Resource resource, Revision revision, Depth depth) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)depth), (String)"depth must not be null", (Object[])new Object[0]);
        LOGGER.trace("listing info for resource {}@{} and depth ", new Object[]{resource, revision, depth});
        return this.list0(new RepositoryCache(this), resource, revision, depth);
    }

    private Set<Info> list0(RepositoryCache cache, Resource resource, Revision revision, Depth depth) {
        if (Depth.INFINITY == depth) {
            TreeSet<Info> result = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
            this.listRecursively0(cache, resource, revision, result);
            return result;
        }
        Resource resolved = this.resolve(cache, resource, revision, true);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        ListOperation operation = new ListOperation(this.repository, resolved, depth, this.parser);
        Set infoSet = (Set)operation.execute(this.client, this.context);
        cache.putAll(infoSet);
        return infoSet;
    }

    private void listRecursively0(RepositoryCache cache, Resource resource, Revision revision, Set<Info> result) {
        for (Info info : this.list0(cache, resource, revision, Depth.IMMEDIATES)) {
            if (!result.add(info) || !info.isDirectory()) continue;
            this.listRecursively0(cache, info.getResource(), revision, result);
        }
    }

    @Override
    public final void lock(Resource resource, boolean steal) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("locking resource {} (steal: {})", (Object)resource, (Object)steal);
        LockOperation operation = new LockOperation(this.repository, resource, steal);
        operation.execute(this.client, this.context);
    }

    @Override
    public final List<Log> log(Resource resource, Revision startRevision, Revision endRevision, int limit) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)startRevision, (String)"endRevision must not be null", (Object[])new Object[0]);
        LOGGER.trace("retrieving log for resource {} from {} to {} (limit: {})", new Object[]{resource, startRevision, endRevision, limit});
        return this.log0(new RepositoryCache(this), resource, startRevision, endRevision, limit);
    }

    private List<Log> log0(RepositoryCache cache, Resource resource, Revision startRevision, Revision endRevision, int limit) {
        Revision concreteEndRevision;
        Revision concreteStartRevision = cache.getConcreteRevision(startRevision);
        Revision resoledRevision = concreteStartRevision.compareTo(concreteEndRevision = cache.getConcreteRevision(endRevision)) > 0 ? concreteStartRevision : concreteEndRevision;
        Resource resolved = this.resolve(cache, resource, resoledRevision, true);
        if (resolved == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + resoledRevision);
        }
        LogOperation operation = new LogOperation(this.repository, resolved, concreteStartRevision, concreteEndRevision, limit);
        return (List)operation.execute(this.client, this.context);
    }

    @Override
    public void mkdir(Transaction transaction, Resource resource, boolean parent) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("creating folder for resource {} during {} (parent: {})", new Object[]{resource, transaction.getId(), parent});
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Revision revision = cache.getConcreteRevision(Revision.HEAD);
        this.createFolder(transaction, resource, revision, parent);
    }

    @Override
    public void move(Transaction transaction, Resource srcResource, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)srcResource, (String)"srcResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        LOGGER.trace("moving {} to {} during {} (parents: {})", new Object[]{srcResource, targetResource, transaction.getId(), parents});
        this.copy(transaction, srcResource, Revision.HEAD, targetResource, parents);
        this.delete(transaction, srcResource);
    }

    @Override
    public void propertiesDelete(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])properties, (String)"properties must not contain null elements", (Object[])new Object[0]);
        LOGGER.trace("deleting properties {} on {} during {}", new Object[]{properties, resource, transaction.getId()});
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info info = this.info0(cache, resource, Revision.HEAD, true);
        Resource r = this.config.getWorkingResource(transaction).append(resource);
        PropertiesDeleteOperation operation = new PropertiesDeleteOperation(this.repository, r, info, properties);
        operation.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.MODIFIED);
    }

    @Override
    public void propertiesSet(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])properties, (String)"properties must not contain null elements", (Object[])new Object[0]);
        LOGGER.trace("setting properties {} on {} during {}", new Object[]{properties, resource, transaction.getId()});
        RepositoryCache cache = AbstractBaseRepository.fromTransaction(transaction);
        Info info = this.info0(cache, resource, Revision.HEAD, true);
        Resource r = this.config.getWorkingResource(transaction).append(resource);
        PropertiesSetOperation operation = new PropertiesSetOperation(this.repository, r, info, properties);
        operation.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.MODIFIED);
    }

    protected abstract void registerResource(Transaction var1, Resource var2, Revision var3);

    @CheckForNull
    Resource resolve(RepositoryCache cache, Resource resource, Revision revision, boolean resolve) {
        Validate.notNull((Object)cache, (String)"cache must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        if (Revision.HEAD.equals(revision)) {
            ExistsOperation operation = new ExistsOperation(this.repository, resource);
            if (!resolve || ((Boolean)operation.execute(this.client, this.context)).booleanValue()) {
                return resource;
            }
            return null;
        }
        Resource expectedResource = this.config.getVersionedResource(resource, revision);
        if (!resolve) {
            return expectedResource;
        }
        ExistsOperation operation = new ExistsOperation(this.repository, expectedResource);
        if (((Boolean)operation.execute(this.client, this.context)).booleanValue()) {
            return expectedResource;
        }
        Revision head = cache.getConcreteRevision(Revision.HEAD);
        ResolveOperation operation2 = new ResolveOperation(this.repository, resource, head, revision, this.config);
        return (Resource)operation2.execute(this.client, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Transaction transaction) {
        this.validateTransaction(transaction);
        LOGGER.trace("rolling transaction {} back", (Object)transaction.getId());
        try {
            Resource resource = this.config.getTransactionResource(transaction);
            DeleteOperation operation = new DeleteOperation(this.repository, resource, null);
            operation.execute(this.client, this.context);
        }
        finally {
            transaction.invalidate();
        }
    }

    @Override
    public final void unlock(Resource resource, boolean force) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("unlocking {} (force: {})", (Object)resource, (Object)force);
        this.unlock0(new RepositoryCache(this), resource, force);
    }

    private void unlock0(RepositoryCache cache, Resource resource, boolean force) {
        Info info = this.info0(cache, resource, Revision.HEAD, true);
        if (info == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + Revision.HEAD);
        }
        String lockToken = info.getLockToken();
        if (lockToken == null) {
            return;
        }
        UnlockOperation operation = new UnlockOperation(this.repository, resource, lockToken, force);
        operation.execute(this.client, this.context);
    }

    protected void validateTransaction(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        UUID transactionRepositoryId = transaction.getRepositoryId();
        if (!this.repositoryId.equals(transactionRepositoryId)) {
            throw new SubversionException("Transaction invalid: does not belong to this repository");
        }
        if (!transaction.isActive()) {
            throw new SubversionException("Transaction invalid: has already been committed or reverted");
        }
    }

    protected static interface ResourceMapper {
        public Resource getCommitMessageResource(Transaction var1);

        public Resource getCreateTransactionResource();

        public Resource getRegisterResource(Resource var1, Revision var2);

        public Resource getRegisterTransactionResource(Transaction var1);

        public Resource getTransactionResource(Transaction var1);

        public Resource getVersionedResource(Resource var1, Revision var2);

        public Resource getWorkingResource(Transaction var1);
    }
}

