/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class Resource
implements Comparable<Resource> {
    private static final Pattern PATH_PATTERN = Pattern.compile("/");
    public static final Resource ROOT = new Resource("");
    private final String value;

    public static Resource create(String path) {
        if (StringUtils.isEmpty((CharSequence)path) || "/".equals(path)) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        for (String segment : PATH_PATTERN.split(path)) {
            if (StringUtils.isEmpty((CharSequence)segment)) continue;
            sb.append('/');
            sb.append(segment);
        }
        return new Resource(sb.toString());
    }

    private Resource(String value) {
        this.value = value;
    }

    public Resource append(Resource resource) {
        return new Resource(this.value + resource.value);
    }

    @Override
    public int compareTo(Resource other) {
        Validate.notNull((Object)other, (String)"other must not be null", (Object[])new Object[0]);
        return this.value.compareTo(other.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.value.equals(other.value);
    }

    public Resource getParent() {
        if (this.equals(ROOT)) {
            return ROOT;
        }
        int indexOf = this.value.lastIndexOf(47);
        return new Resource(this.value.substring(0, indexOf));
    }

    public String getValue() {
        return this.value;
    }

    public String getValueWithoutLeadingSeparator() {
        if (this.equals(ROOT)) {
            return "";
        }
        return this.value.substring(1);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

