/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import java.util.Comparator;
import java.util.UUID;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.Validate;

public interface Info {
    public static final Comparator<Info> RESOURCE_COMPARATOR = new Comparator<Info>(){

        @Override
        public int compare(Info i1, Info i2) {
            Validate.notNull((Object)i1, (String)"i1 must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)i2, (String)"i2 must not be null", (Object[])new Object[0]);
            return i1.getResource().compareTo(i2.getResource());
        }
    };

    @CheckForNull
    public String getLockOwner();

    @CheckForNull
    public String getLockToken();

    @CheckForNull
    public String getMd5();

    public ResourceProperty[] getProperties();

    public UUID getRepositoryId();

    public Resource getResource();

    public Revision getRevision();

    public boolean isDirectory();

    public boolean isFile();

    public boolean isLocked();
}

