/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.app.miioMapClient;

import de.sg_o.app.miio.base.Token;
import de.sg_o.app.miio.util.ByteArray;
import de.sg_o.app.miioMapServer.VacuumMap;
import de.sg_o.proto.MapErrorProto;
import de.sg_o.proto.MapInfoProto;
import de.sg_o.proto.MapPackageProto;
import de.sg_o.proto.MapRequestProto;
import de.sg_o.proto.MapSlamProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;

public class Client {
    private final Socket socket;
    private final Token tk;

    public Client(String host, int port, Token tk, int timeout) throws IOException {
        this.socket = new Socket(host, port);
        if (timeout < 0) {
            timeout = 1000;
        }
        this.socket.setSoTimeout(timeout);
        if (tk == null) {
            throw new IOException("No token provided");
        }
        this.tk = tk;
    }

    public void close() {
        try {
            MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
            request.setCode(MapRequestProto.MapRequest.RequestCode.END_COMMUNICATION);
            OutputStream outputStream = this.socket.getOutputStream();
            request.build().writeDelimitedTo(outputStream);
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean authenticate() throws IOException {
        MapRequestProto.MapRequest info;
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.AUTHENTICATE);
        request.setOpt(ByteArray.bytesToHex((byte[])this.tk.encrypt("hello".getBytes("ASCII"))));
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        long endTime = System.currentTimeMillis() + (long)this.socket.getSoTimeout();
        while ((info = MapRequestProto.MapRequest.parseDelimitedFrom((InputStream)inputStream)) == null) {
            if (this.socket.getSoTimeout() == 0 || System.currentTimeMillis() <= endTime) continue;
            throw new IOException("Timeout");
        }
        if (!info.getCode().equals((Object)MapRequestProto.MapRequest.RequestCode.AUTHENTICATE)) {
            return false;
        }
        byte[] response = this.tk.decrypt(ByteArray.hexToBytes((String)info.getOpt()));
        return Arrays.equals(new byte[]{111, 107}, response);
    }

    public synchronized MapInfoProto.MapInfo getMapInfo() throws IOException {
        MapInfoProto.MapInfo info;
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.MAP_INFO);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        long endTime = System.currentTimeMillis() + (long)this.socket.getSoTimeout();
        while ((info = MapInfoProto.MapInfo.parseDelimitedFrom((InputStream)inputStream)) == null) {
            if (this.socket.getSoTimeout() == 0 || System.currentTimeMillis() <= endTime) continue;
            throw new IOException("Timeout");
        }
        if (!info.getError().getCode().equals((Object)MapErrorProto.MapError.ErrorCode.NONE)) {
            throw new IOException(info.getError().getCode().toString());
        }
        return info;
    }

    public synchronized MapPackageProto.MapPackage getActiveMap() throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_ACTIVE_MAP);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMap(inputStream);
    }

    public synchronized MapSlamProto.MapSlam getActiveMapSlam(int start) throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_ACTIVE_MAP_SLAM);
        request.setOptInt(start);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMapSlam(inputStream);
    }

    public synchronized VacuumMap getActive() throws IOException {
        return new VacuumMap(this.getActiveMap(), this.getActiveMapSlam(0), 0);
    }

    public void updateActivePath(VacuumMap map) {
        int currentSlamLength = map.getPathSize();
        try {
            map.appendMapSlam(this.getActiveMapSlam(currentSlamLength));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized MapPackageProto.MapPackage getPreviousMap() throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_PREVIOUS_MAP);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMap(inputStream);
    }

    public synchronized MapSlamProto.MapSlam getPreviousMapSlam(int start) throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_PREVIOUS_MAP_SLAM);
        request.setOptInt(start);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMapSlam(inputStream);
    }

    public synchronized VacuumMap getPrevious() throws IOException {
        return new VacuumMap(this.getPreviousMap(), this.getPreviousMapSlam(0), 0);
    }

    public synchronized MapPackageProto.MapPackage getOldMap(String name) throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_OLD_MAP);
        request.setOpt(name);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMap(inputStream);
    }

    public synchronized MapSlamProto.MapSlam getOldMapSlam(String name, int start) throws IOException {
        MapRequestProto.MapRequest.Builder request = MapRequestProto.MapRequest.newBuilder();
        request.setCode(MapRequestProto.MapRequest.RequestCode.GET_OLD_MAP_SLAM);
        request.setOpt(name);
        request.setOptInt(start);
        OutputStream outputStream = this.socket.getOutputStream();
        InputStream inputStream = this.socket.getInputStream();
        request.build().writeDelimitedTo(outputStream);
        return this.getMapSlam(inputStream);
    }

    public synchronized VacuumMap getOld(String name) throws IOException {
        return new VacuumMap(this.getOldMap(name), this.getOldMapSlam(name, 0), 0);
    }

    private MapPackageProto.MapPackage getMap(InputStream inputStream) throws IOException {
        MapPackageProto.MapPackage map;
        if (inputStream == null) {
            throw new IOException("InputStream null");
        }
        long endTime = System.currentTimeMillis() + (long)this.socket.getSoTimeout();
        while ((map = MapPackageProto.MapPackage.parseDelimitedFrom((InputStream)inputStream)) == null) {
            if (this.socket.getSoTimeout() == 0 || System.currentTimeMillis() <= endTime) continue;
            throw new IOException("Timeout");
        }
        if (!map.getError().getCode().equals((Object)MapErrorProto.MapError.ErrorCode.NONE)) {
            throw new IOException(map.getError().getCode().toString());
        }
        return map;
    }

    private MapSlamProto.MapSlam getMapSlam(InputStream inputStream) throws IOException {
        MapSlamProto.MapSlam slam;
        if (inputStream == null) {
            throw new IOException("InputStream null");
        }
        long endTime = System.currentTimeMillis() + (long)this.socket.getSoTimeout();
        while ((slam = MapSlamProto.MapSlam.parseDelimitedFrom((InputStream)inputStream)) == null) {
            if (this.socket.getSoTimeout() == 0 || System.currentTimeMillis() <= endTime) continue;
            throw new IOException("Timeout");
        }
        if (!slam.getError().getCode().equals((Object)MapErrorProto.MapError.ErrorCode.NONE)) {
            throw new IOException(slam.getError().getCode().toString());
        }
        return slam;
    }
}

