/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameMatrixImpl;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.QuadraticArrays;
import de.sfuhrm.sudoku.Riddle;

class RiddleImpl
extends GameMatrixImpl
implements Riddle {
    private boolean[][] writeable;

    RiddleImpl(GameSchema inGameSchema) {
        super(inGameSchema);
        int width = inGameSchema.getWidth();
        this.writeable = new boolean[width][width];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                this.setWritable(i, j, true);
            }
        }
    }

    @Override
    public final boolean getWritable(int row, int column) {
        return this.writeable[row][column];
    }

    @Override
    public final void setWritable(int row, int column, boolean set) {
        this.writeable[row][column] = set;
    }

    @Override
    public final RiddleImpl clone() {
        RiddleImpl clone = (RiddleImpl)super.clone();
        clone.writeable = QuadraticArrays.cloneArray(this.writeable);
        return clone;
    }
}

