/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.GameSchemas;

public final class QuadraticArrays {
    private static final int DECIMAL = 10;

    private QuadraticArrays() {
    }

    static int[][] cloneArray(int[][] array) {
        int[][] result = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new int[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static byte[][] cloneArray(byte[][] array) {
        byte[][] result = new byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new byte[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static boolean[][] cloneArray(boolean[][] array) {
        boolean[][] result = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new boolean[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    public static byte[][] parse(GameSchema gameSchema, String ... rows) {
        if (rows.length != gameSchema.getWidth()) {
            throw new IllegalArgumentException("Array must have " + gameSchema.getWidth() + " elements");
        }
        byte[][] result = new byte[gameSchema.getWidth()][gameSchema.getWidth()];
        for (int r = 0; r < rows.length; ++r) {
            String row = rows[r];
            if (row.contains(" ")) {
                String[] parts = row.split(" ");
                if (parts.length != gameSchema.getWidth()) {
                    throw new IllegalArgumentException("Row " + r + " must have " + gameSchema.getWidth() + " elements, but has " + parts.length);
                }
                for (int c = 0; c < gameSchema.getWidth(); ++c) {
                    String v = parts[c];
                    result[r][c] = QuadraticArrays.stringToValue(gameSchema, v);
                }
                continue;
            }
            if (rows[r].length() != gameSchema.getWidth()) {
                throw new IllegalArgumentException("Row " + r + " must have " + gameSchema.getWidth() + " elements: " + rows[r]);
            }
            for (int c = 0; c < gameSchema.getWidth(); ++c) {
                char v = rows[r].charAt(c);
                result[r][c] = QuadraticArrays.charToValue(gameSchema, v);
            }
        }
        return result;
    }

    private static byte stringToValue(GameSchema gameSchema, String value) {
        byte result = 0;
        for (char c : value.toCharArray()) {
            result = (byte)(result * 10);
            if (c < '1' || c > '9') continue;
            result = (byte)(c - 49 + gameSchema.getMinimumValue());
        }
        if (result == 0) {
            result = gameSchema.getUnsetValue();
        }
        return result;
    }

    private static byte charToValue(GameSchema gameSchema, char value) {
        byte result = value >= '1' && value <= '9' ? (byte)(value - 49 + gameSchema.getMinimumValue()) : gameSchema.getUnsetValue();
        return result;
    }

    public static byte[][] parse(String ... rows) {
        for (GameSchema schema : GameSchemas.getSupportedGameSchemas()) {
            if (rows.length != schema.getWidth()) continue;
            return QuadraticArrays.parse(schema, rows);
        }
        throw new IllegalArgumentException("Input arrays has unknown dimension");
    }

    static String toString(GameMatrix gameMatrix) {
        StringBuilder sb = new StringBuilder();
        int maxWidth = Integer.toString(gameMatrix.getSchema().getMaximumValue()).length();
        char fillChar = '_';
        char space = ' ';
        StringBuilder fill = new StringBuilder();
        for (int i = 0; i < maxWidth; ++i) {
            fill.append(fillChar);
        }
        for (int row = 0; row < gameMatrix.getSchema().getWidth(); ++row) {
            for (int column = 0; column < gameMatrix.getSchema().getWidth(); ++column) {
                byte v;
                if (column != 0) {
                    sb.append(space);
                }
                if ((v = gameMatrix.get(row, column)) != gameMatrix.getSchema().getUnsetValue()) {
                    String value = Integer.toString(v - gameMatrix.getSchema().getMinimumValue() + 1);
                    for (int f = value.length(); f < maxWidth; ++f) {
                        sb.append(fillChar);
                    }
                    sb.append(value);
                    continue;
                }
                sb.append((CharSequence)fill);
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

