/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameSchema;

class GameSchemaImpl
implements GameSchema {
    private final byte unsetValue;
    private final byte minimumValue;
    private final byte maximumValue;
    private final int width;
    private final int totalFields;
    private final int blockWidth;
    private final int blockCount;
    private final int bitMask;

    GameSchemaImpl(byte inUnsetValue, byte inMinimumValue, byte inMaximumValue, int inWidth, int inBlockWidth) {
        this.unsetValue = inUnsetValue;
        if (inMinimumValue <= inUnsetValue && inUnsetValue <= inMaximumValue) {
            throw new IllegalArgumentException("unsetValue must be outside of minimumValue and maximumValue");
        }
        if (inMaximumValue - inMinimumValue + 1 != inWidth) {
            throw new IllegalArgumentException("maximumValue - minimumValue + 1 must be equal width");
        }
        this.minimumValue = inMinimumValue;
        this.maximumValue = inMaximumValue;
        if (inWidth != inBlockWidth * inBlockWidth) {
            throw new IllegalArgumentException("Width must be blockWidth * blockWidth");
        }
        if (inWidth <= 0) {
            throw new IllegalArgumentException("Width must be >= 0");
        }
        this.width = inWidth;
        this.blockWidth = inBlockWidth;
        this.totalFields = inWidth * inWidth;
        if (inWidth % inBlockWidth != 0) {
            throw new IllegalArgumentException("Width can not be divided by block count");
        }
        this.blockCount = inWidth / inBlockWidth;
        int myBitMask = 0;
        for (int i = this.minimumValue; i <= this.maximumValue; ++i) {
            myBitMask |= 1 << i;
        }
        this.bitMask = myBitMask;
    }

    @Override
    public byte getUnsetValue() {
        return this.unsetValue;
    }

    @Override
    public byte getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public byte getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getTotalFields() {
        return this.totalFields;
    }

    @Override
    public int getBlockWidth() {
        return this.blockWidth;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public boolean validValue(byte b) {
        return b == this.unsetValue || b >= this.minimumValue && b <= this.maximumValue;
    }

    @Override
    public boolean validCoords(int row, int column) {
        return row >= 0 && row < this.width && column >= 0 && column < this.width;
    }

    @Override
    public boolean validBitMask(int mask) {
        return (mask & ~this.bitMask) == 0;
    }

    public String toString() {
        return String.format("%dx%d", this.width, this.width);
    }
}

