/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.CellIndex;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.QuadraticArrays;
import java.util.Arrays;

class GameMatrixImpl
implements Cloneable,
GameMatrix {
    private final GameSchema gameSchema;
    private byte[][] data;

    GameMatrixImpl(GameSchema inGameSchema) {
        this.gameSchema = inGameSchema;
        this.data = new byte[inGameSchema.getWidth()][inGameSchema.getWidth()];
    }

    @Override
    public final void setAll(byte[][] initializationData) {
        for (int i = 0; i < this.gameSchema.getWidth(); ++i) {
            for (int j = 0; j < this.gameSchema.getWidth(); ++j) {
                this.set(j, i, initializationData[j][i]);
            }
        }
    }

    @Override
    public GameSchema getSchema() {
        return this.gameSchema;
    }

    protected final void row(int index, byte[] target) {
        assert (target.length == this.gameSchema.getWidth());
        System.arraycopy(this.data[index], 0, target, 0, this.gameSchema.getWidth());
    }

    protected final void column(int index, byte[] target) {
        assert (target.length == this.gameSchema.getWidth());
        for (int i = 0; i < this.gameSchema.getWidth(); ++i) {
            target[i] = this.data[i][index];
        }
    }

    protected final void block(int row, int column, byte[] target) {
        assert (target.length == this.gameSchema.getWidth());
        assert (this.getSchema().validCoords(row, column));
        int k = 0;
        int roundRow = this.roundToBlock(row);
        int roundColumn = this.roundToBlock(column);
        for (int i = 0; i < this.gameSchema.getBlockWidth(); ++i) {
            for (int j = 0; j < this.gameSchema.getBlockWidth(); ++j) {
                target[k++] = this.data[roundRow + i][roundColumn + j];
            }
        }
    }

    @Override
    public final void clear() {
        byte unsetValue = this.gameSchema.getUnsetValue();
        for (int i = 0; i < this.gameSchema.getWidth(); ++i) {
            for (int j = 0; j < this.gameSchema.getWidth(); ++j) {
                this.set(j, i, unsetValue);
            }
        }
    }

    @Override
    public final byte get(int row, int column) {
        assert (this.getSchema().validCoords(row, column));
        return this.data[row][column];
    }

    @Override
    public void set(int row, int column, byte value) {
        assert (this.getSchema().validCoords(row, column));
        assert (this.getSchema().validValue(value)) : "Value out of range: " + value;
        this.data[row][column] = value;
    }

    @Override
    public int getSetCount() {
        int count = 0;
        for (int i = 0; i < this.gameSchema.getWidth(); ++i) {
            for (int j = 0; j < this.gameSchema.getWidth(); ++j) {
                assert (this.getSchema().validValue(this.data[i][j]));
                if (this.data[i][j] == this.gameSchema.getUnsetValue()) continue;
                ++count;
            }
        }
        assert (count >= 0 && count <= this.gameSchema.getTotalFields());
        return count;
    }

    @Override
    public final byte[][] getArray() {
        return QuadraticArrays.cloneArray(this.data);
    }

    public final String toString() {
        return QuadraticArrays.toString(this);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameMatrixImpl)) {
            return false;
        }
        GameMatrixImpl other = (GameMatrixImpl)obj;
        return Arrays.deepEquals((Object[])this.data, (Object[])other.data);
    }

    public GameMatrixImpl clone() {
        GameMatrixImpl clone;
        try {
            clone = (GameMatrixImpl)super.clone();
            clone.data = QuadraticArrays.cloneArray(this.data);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        return clone;
    }

    protected static int findDuplicateBits(GameSchema gameSchema, byte[] cellData) {
        int currentMask = 0;
        int duplicates = 0;
        byte unset = gameSchema.getUnsetValue();
        for (int i = 0; i < cellData.length; ++i) {
            byte cellValue = cellData[i];
            if (cellValue == unset) continue;
            int shifted = 1 << cellData[i];
            duplicates |= currentMask & shifted;
            currentMask |= shifted;
        }
        return duplicates & 0xFFFFFFFE;
    }

    protected static int getNumberMask(GameSchema schema, byte[] cellData) {
        int currentMask = 0;
        byte unset = schema.getUnsetValue();
        for (int i = 0; i < cellData.length; ++i) {
            if (cellData[i] == unset) continue;
            currentMask |= 1 << cellData[i];
        }
        return currentMask & 0xFFFFFFFE;
    }

    @Override
    public final boolean isValid() {
        int i;
        boolean result = true;
        byte[] tmpData = new byte[this.gameSchema.getWidth()];
        for (i = 0; result && i < this.gameSchema.getWidth(); result &= GameMatrixImpl.findDuplicateBits(this.gameSchema, tmpData) == 0, ++i) {
            this.row(i, tmpData);
        }
        for (i = 0; result && i < this.gameSchema.getWidth(); result &= GameMatrixImpl.findDuplicateBits(this.gameSchema, tmpData) == 0, ++i) {
            this.column(i, tmpData);
        }
        for (i = 0; result && i < this.gameSchema.getWidth(); i += this.gameSchema.getBlockWidth()) {
            for (int j = 0; result && j < this.gameSchema.getWidth(); result &= GameMatrixImpl.findDuplicateBits(this.gameSchema, tmpData) == 0, j += this.gameSchema.getBlockWidth()) {
                this.block(i, j, tmpData);
            }
        }
        return result;
    }

    int getRowFreeMask(int row) {
        byte[] tmpData = new byte[this.gameSchema.getWidth()];
        this.row(row, tmpData);
        return ~GameMatrixImpl.getNumberMask(this.gameSchema, tmpData) & this.getSchema().getBitMask();
    }

    int getColumnFreeMask(int column) {
        byte[] tmpData = new byte[this.gameSchema.getWidth()];
        this.column(column, tmpData);
        return ~GameMatrixImpl.getNumberMask(this.gameSchema, tmpData) & this.getSchema().getBitMask();
    }

    int getBlockFreeMask(int row, int column) {
        byte[] tmpData = new byte[this.getSchema().getBlockWidth() * this.getSchema().getBlockWidth()];
        this.block(row, column, tmpData);
        return ~GameMatrixImpl.getNumberMask(this.gameSchema, tmpData) & this.getSchema().getBitMask();
    }

    int getFreeMask(int row, int column) {
        int free = this.gameSchema.getBitMask();
        assert (this.gameSchema.validCoords(row, column));
        free &= this.getRowFreeMask(row);
        free &= this.getColumnFreeMask(column);
        return free &= this.getBlockFreeMask(row, column);
    }

    @Override
    public final boolean canSet(int row, int column, byte value) {
        assert (this.gameSchema.validCoords(row, column));
        assert (this.gameSchema.validValue(value));
        if (value == this.gameSchema.getUnsetValue()) {
            return true;
        }
        int free = this.getFreeMask(row, column);
        return (free & 1 << value) != 0;
    }

    protected int roundToBlock(int in) {
        return in - in % this.gameSchema.getBlockWidth();
    }

    FreeCellResult findLeastFreeCell(CellIndex rowColumnResult) {
        int minimumBits = -1;
        int minimumRow = -1;
        int minimumColumn = -1;
        int width = this.getSchema().getWidth();
        byte unset = this.getSchema().getUnsetValue();
        block0: for (int row = 0; row < width; ++row) {
            int rowMask = this.getRowFreeMask(row);
            if (rowMask == 0) continue;
            for (int column = 0; column < width; ++column) {
                if (this.get(row, column) != unset) continue;
                int free = this.getFreeMask(row, column);
                if (free == 0) {
                    return FreeCellResult.CONTRADICTION;
                }
                int bits = Integer.bitCount(free);
                assert (bits <= width);
                if (bits == 0 || minimumBits != -1 && bits >= minimumBits) continue;
                minimumColumn = column;
                minimumRow = row;
                minimumBits = bits;
                if (minimumBits == 1) break block0;
            }
        }
        rowColumnResult.row = minimumRow;
        rowColumnResult.column = minimumColumn;
        return minimumBits != -1 ? FreeCellResult.FOUND : FreeCellResult.NONE_FREE;
    }

    static enum FreeCellResult {
        FOUND,
        NONE_FREE,
        CONTRADICTION;

    }
}

