/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.CachedGameMatrixImpl;
import de.sfuhrm.sudoku.CellIndex;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameMatrixImpl;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.GameSchemas;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.RiddleImpl;
import de.sfuhrm.sudoku.Solver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public final class Creator {
    private static final int CREATE_RIDDLE_RANDOM_CLEAR = 10;
    public static final int RIDDLE_4X4_EMPTY_FIELDS_VERY_EASY = 6;
    public static final int RIDDLE_4X4_EMPTY_FIELDS_EASY = 7;
    public static final int RIDDLE_4X4_EMPTY_FIELDS_MEDIUM = 9;
    public static final int RIDDLE_4X4_EMPTY_FIELDS_HARD = 10;
    public static final int RIDDLE_4X4_EMPTY_FIELDS_VERY_HARD = 12;
    public static final int RIDDLE_9X9_EMPTY_FIELDS_VERY_EASY = 31;
    public static final int RIDDLE_9X9_EMPTY_FIELDS_EASY = 45;
    public static final int RIDDLE_9X9_EMPTY_FIELDS_MEDIUM = 49;
    public static final int RIDDLE_9X9_EMPTY_FIELDS_HARD = 53;
    public static final int RIDDLE_9X9_EMPTY_FIELDS_VERY_HARD = 58;
    public static final int RIDDLE_16X16_EMPTY_FIELDS_VERY_EASY = 90;
    public static final int RIDDLE_16X16_EMPTY_FIELDS_EASY = 100;
    public static final int RIDDLE_16X16_EMPTY_FIELDS_MEDIUM = 120;
    public static final int RIDDLE_16X16_EMPTY_FIELDS_HARD = 130;
    public static final int RIDDLE_16X16_EMPTY_FIELDS_VERY_HARD = 140;
    public static final int RIDDLE_25X25_EMPTY_FIELDS_VERY_EASY = 200;
    public static final int RIDDLE_25X25_EMPTY_FIELDS_EASY = 220;
    public static final int RIDDLE_25X25_EMPTY_FIELDS_MEDIUM = 240;
    public static final int RIDDLE_25X25_EMPTY_FIELDS_HARD = 260;
    public static final int RIDDLE_25X25_EMPTY_FIELDS_VERY_HARD = 280;
    private final Function<GameMatrix, Boolean> resultConsumer;
    private final GameMatrixImpl riddle;
    private final GameSchema schema;
    private GameMatrix winner;
    private final Random random;

    private Creator(GameSchema gameSchema) {
        this.schema = gameSchema;
        this.riddle = new CachedGameMatrixImpl(gameSchema);
        this.random = new Random();
        this.resultConsumer = t -> {
            this.winner = t;
            return Boolean.TRUE;
        };
    }

    static int getSetBitOffset(int mask, int bitIndex) {
        int count = 0;
        int workingMask = mask;
        int low = Integer.numberOfTrailingZeros(workingMask);
        assert (((workingMask >>>= low) & 1) == 1 || workingMask == 0);
        int i = low;
        while (workingMask != 0) {
            if ((workingMask & 1) != 0) {
                if (count == bitIndex) {
                    return i;
                }
                ++count;
            }
            workingMask >>>= 1;
            ++i;
        }
        return -1;
    }

    public static GameMatrix createFull() {
        return Creator.createFull(GameSchemas.SCHEMA_9X9);
    }

    public static GameMatrix createFull(GameSchema schema) {
        BacktrackingResult backtrackingResult;
        Creator c = new Creator(schema);
        do {
            c.riddle.clear();
            for (int i = 0; i < c.riddle.getSchema().getBlockCount(); ++i) {
                c.fillBlock(i * schema.getBlockWidth(), i * schema.getBlockWidth());
            }
        } while ((backtrackingResult = c.backtrack(schema.getTotalFields() - c.riddle.getSetCount(), new CellIndex())) != BacktrackingResult.FOUND);
        return c.winner;
    }

    public static GameMatrix createVariant(GameMatrix fullyFilled) {
        int offset;
        int distance;
        boolean swap;
        int i;
        GameSchema schema = fullyFilled.getSchema();
        GameMatrixImpl target = new GameMatrixImpl(schema);
        Random random = new Random();
        byte[] substitution = Creator.createNumbersToDistribute(schema, random, 1);
        for (int row = 0; row < schema.getWidth(); ++row) {
            for (int column = 0; column < schema.getWidth(); ++column) {
                byte original = fullyFilled.get(row, column);
                if (original == schema.getUnsetValue()) {
                    throw new IllegalArgumentException("There are unset fields in the given GameMatrix");
                }
                byte substitute = substitution[original - 1];
                target.set(row, column, substitute);
            }
        }
        for (i = 0; i < schema.getBlockCount(); ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapRow(target, i * schema.getBlockWidth() + offset, i * schema.getBlockWidth() + offset + distance);
        }
        for (i = 0; i < schema.getBlockCount(); ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapColumn(target, i * schema.getBlockWidth() + offset, i * schema.getBlockWidth() + offset + distance);
        }
        return target;
    }

    static void swapRow(GameMatrix matrix, int rowA, int rowB) {
        int width = matrix.getSchema().getWidth();
        for (int column = 0; column < width; ++column) {
            byte av = matrix.get(rowA, column);
            byte bv = matrix.get(rowB, column);
            matrix.set(rowB, column, av);
            matrix.set(rowA, column, bv);
        }
    }

    static void swapColumn(GameMatrix matrix, int columnA, int columnB) {
        for (int row = 0; row < matrix.getSchema().getWidth(); ++row) {
            byte av = matrix.get(row, columnA);
            byte bv = matrix.get(row, columnB);
            matrix.set(row, columnB, av);
            matrix.set(row, columnA, bv);
        }
    }

    static byte[] createNumbersToDistribute(GameSchema schema, Random r, int multiplicity) {
        int totalNumbers = schema.getMaximumValue() - schema.getMinimumValue() + 1;
        ArrayList<Integer> numbersToDistribute = new ArrayList<Integer>(totalNumbers * multiplicity);
        for (int number = schema.getMinimumValue(); number <= schema.getMaximumValue(); ++number) {
            for (int j = 0; j < multiplicity; ++j) {
                numbersToDistribute.add(number);
            }
        }
        Collections.shuffle(numbersToDistribute, r);
        byte[] numbersToDistributeArray = new byte[numbersToDistribute.size()];
        int k = 0;
        for (Integer number : numbersToDistribute) {
            numbersToDistributeArray[k++] = number.byteValue();
        }
        return numbersToDistributeArray;
    }

    private static boolean canClear(RiddleImpl riddle, int row, int column) {
        GameSchema schema = riddle.getSchema();
        assert (riddle.get(row, column) != schema.getUnsetValue());
        int freeMask = riddle.getFreeMask(row, column);
        int freeVals = Integer.bitCount(freeMask);
        if (freeVals == 0) {
            return true;
        }
        byte old = riddle.get(row, column);
        riddle.set(row, column, schema.getUnsetValue());
        Solver s = new Solver(riddle);
        s.setLimit(2);
        List<GameMatrix> results = s.solve();
        boolean result = results.size() == 1;
        riddle.set(row, column, old);
        return result;
    }

    public static Riddle createRiddle(GameMatrix fullMatrix) {
        int row;
        int column;
        Random random = new Random();
        GameSchema schema = fullMatrix.getSchema();
        int width = schema.getWidth();
        byte unset = schema.getUnsetValue();
        RiddleImpl cur = new RiddleImpl(schema);
        cur.setAll(fullMatrix.getArray());
        int randomClearCount = 0;
        while (randomClearCount < 10) {
            column = random.nextInt(schema.getWidth());
            row = random.nextInt(schema.getWidth());
            if (cur.get(row, column) == schema.getUnsetValue()) continue;
            if (Creator.canClear(cur, row, column)) {
                cur.set(row, column, schema.getUnsetValue());
                continue;
            }
            ++randomClearCount;
        }
        for (column = 0; column < width; ++column) {
            for (row = 0; row < width; ++row) {
                if (unset == cur.get(row, column) || !Creator.canClear(cur, row, column)) continue;
                cur.set(row, column, unset);
            }
        }
        for (column = 0; column < width; ++column) {
            for (row = 0; row < width; ++row) {
                cur.setWritable(row, column, cur.get(row, column) == unset);
            }
        }
        return cur;
    }

    public static Riddle createRiddle(GameMatrix fullMatrix, int maxNumbersToClear) {
        int j;
        int i;
        Random random = new Random();
        GameSchema schema = fullMatrix.getSchema();
        int width = schema.getWidth();
        byte unset = schema.getUnsetValue();
        RiddleImpl cur = new RiddleImpl(schema);
        cur.setAll(fullMatrix.getArray());
        int numbersToClear = maxNumbersToClear;
        int randomClearCount = 0;
        while (numbersToClear > 0 && randomClearCount < 10) {
            i = random.nextInt(width);
            j = random.nextInt(width);
            if (cur.get(j, i) == schema.getUnsetValue()) continue;
            if (Creator.canClear(cur, j, i)) {
                cur.set(j, i, schema.getUnsetValue());
                --numbersToClear;
                continue;
            }
            ++randomClearCount;
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < width; ++j) {
                if (numbersToClear <= 0 || unset == cur.get(j, i) || !Creator.canClear(cur, j, i)) continue;
                cur.set(j, i, unset);
                --numbersToClear;
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < width; ++j) {
                cur.setWritable(j, i, cur.get(j, i) == unset);
            }
        }
        return cur;
    }

    private void fillBlock(int row, int column) {
        int blockSize = this.schema.getBlockWidth();
        assert (this.schema.validCoords(row, column));
        assert (row % blockSize == 0);
        assert (column % blockSize == 0);
        byte[] numbers = Creator.createNumbersToDistribute(this.schema, this.random, 1);
        int k = 0;
        for (int colOfs = 0; colOfs < blockSize; ++colOfs) {
            for (int rowOfs = 0; rowOfs < blockSize; ++rowOfs) {
                this.riddle.set(row + rowOfs, column + colOfs, numbers[k++]);
            }
        }
    }

    private BacktrackingResult backtrack(int numbersToDistribute, CellIndex minimumCell) {
        if (numbersToDistribute == 0) {
            assert (this.riddle.isValid()) : "Riddle went non-valid while backtracking";
            if (this.resultConsumer.apply(this.riddle).booleanValue()) {
                return BacktrackingResult.FOUND;
            }
            return BacktrackingResult.CONTINUE;
        }
        GameMatrixImpl.FreeCellResult result = this.riddle.findLeastFreeCell(minimumCell);
        switch (result) {
            case CONTRADICTION: 
            case NONE_FREE: {
                return BacktrackingResult.CONTRADICTION;
            }
        }
        int minimumRow = minimumCell.row;
        int minimumColumn = minimumCell.column;
        int minimumFree = this.riddle.getFreeMask(minimumRow, minimumColumn);
        int minimumBits = Integer.bitCount(minimumFree);
        for (int bit = 0; bit < minimumBits; ++bit) {
            int number = Creator.getSetBitOffset(minimumFree, bit);
            assert (number >= this.schema.getMinimumValue() && number <= this.schema.getMaximumValue());
            assert ((this.riddle.getFreeMask(minimumRow, minimumColumn) & 1 << number) == 1 << number);
            this.riddle.set(minimumRow, minimumColumn, (byte)number);
            assert ((this.riddle.getFreeMask(minimumRow, minimumColumn) & 1 << number) == 0);
            BacktrackingResult subResult = this.backtrack(numbersToDistribute - 1, minimumCell);
            if (subResult != BacktrackingResult.FOUND) continue;
            return subResult;
        }
        this.riddle.set(minimumRow, minimumColumn, this.schema.getUnsetValue());
        return BacktrackingResult.CONTINUE;
    }

    static enum BacktrackingResult {
        FOUND,
        CONTINUE,
        CONTRADICTION;

    }
}

