/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameMatrixImpl;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.QuadraticArrays;
import java.util.Arrays;

class CachedGameMatrixImpl
extends GameMatrixImpl {
    private int[] rowFree;
    private int[] columnFree;
    private int[][] blockFree;
    private int setCount;

    CachedGameMatrixImpl(GameSchema schema) {
        super(schema);
        int i;
        int blockCount = schema.getBlockCount();
        int width = schema.getWidth();
        this.blockFree = new int[blockCount][blockCount];
        this.rowFree = new int[width];
        this.columnFree = new int[width];
        for (i = 0; i < width; ++i) {
            this.rowFree[i] = schema.getBitMask();
            this.columnFree[i] = schema.getBitMask();
        }
        for (i = 0; i < blockCount; ++i) {
            for (int j = 0; j < blockCount; ++j) {
                this.blockFree[i][j] = schema.getBitMask();
            }
        }
    }

    @Override
    int getBlockFreeMask(int row, int column) {
        int blockWidth = this.getSchema().getBlockWidth();
        return this.blockFree[row / blockWidth][column / blockWidth];
    }

    @Override
    int getColumnFreeMask(int column) {
        return this.columnFree[column];
    }

    @Override
    int getRowFreeMask(int row) {
        return this.rowFree[row];
    }

    @Override
    int getFreeMask(int row, int column) {
        int blockWidth = this.getSchema().getBlockWidth();
        return this.rowFree[row] & this.columnFree[column] & this.blockFree[row / blockWidth][column / blockWidth];
    }

    @Override
    public void set(int row, int column, byte value) {
        int bitMask;
        GameSchema schema = this.getSchema();
        assert (schema.validValue(value));
        byte oldValue = super.get(row, column);
        assert (schema.validValue(oldValue));
        byte unset = schema.getUnsetValue();
        int blockWidth = schema.getBlockWidth();
        if (oldValue != unset) {
            bitMask = 1 << oldValue;
            int n = row;
            this.rowFree[n] = this.rowFree[n] | bitMask;
            int n2 = column;
            this.columnFree[n2] = this.columnFree[n2] | bitMask;
            int[] nArray = this.blockFree[row / blockWidth];
            int n3 = column / blockWidth;
            nArray[n3] = nArray[n3] | bitMask;
            --this.setCount;
            assert (this.setCount >= 0);
        }
        if (value != unset) {
            assert ((this.getFreeMask(row, column) & 1 << value) != 0) : "Passed value " + value + " is already used, would destroy class invariant";
            bitMask = ~(1 << value);
            int n = row;
            this.rowFree[n] = this.rowFree[n] & bitMask;
            int n4 = column;
            this.columnFree[n4] = this.columnFree[n4] & bitMask;
            int[] nArray = this.blockFree[row / blockWidth];
            int n5 = column / blockWidth;
            nArray[n5] = nArray[n5] & bitMask;
            ++this.setCount;
            assert (this.setCount <= this.getSchema().getTotalFields());
        }
        assert (this.getSchema().validBitMask(this.rowFree[row])) : "Row free mask is invalid: " + this.rowFree[row];
        assert (this.getSchema().validBitMask(this.columnFree[column])) : "Column free mask is invalid: " + this.columnFree[column];
        assert (this.getSchema().validBitMask(this.blockFree[row / blockWidth][column / blockWidth])) : "Block free mask is invalid: " + this.blockFree[row / blockWidth][column / blockWidth];
        super.set(row, column, value);
    }

    @Override
    public int getSetCount() {
        return this.setCount;
    }

    @Override
    public CachedGameMatrixImpl clone() {
        CachedGameMatrixImpl clone = (CachedGameMatrixImpl)super.clone();
        clone.blockFree = QuadraticArrays.cloneArray(this.blockFree);
        clone.columnFree = Arrays.copyOf(this.columnFree, this.columnFree.length);
        clone.rowFree = Arrays.copyOf(this.rowFree, this.rowFree.length);
        return clone;
    }
}

