/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class JsonArrayFormatter
extends AbstractTextFormatter {
    private int count;
    private boolean indent;
    private static final int INDENT_SPACES = 2;

    public JsonArrayFormatter() {
        this.setUnknownCellContentCharacter("0");
        this.count = 0;
    }

    private static void appendIndent(int level, StringBuilder to) {
        assert (level >= 0);
        assert (to != null);
        int total = level * 2;
        for (int i = 0; i < total; ++i) {
            to.append(' ');
        }
    }

    @Override
    public String format(GameMatrix matrix) {
        StringBuilder sb = new StringBuilder();
        if (this.count != 0) {
            sb.append(",");
            if (this.indent) {
                sb.append(this.getLineSeparator());
            }
        }
        if (this.indent) {
            JsonArrayFormatter.appendIndent(1, sb);
        }
        sb.append("[");
        if (this.indent) {
            sb.append(this.getLineSeparator());
        }
        for (int row = 0; row < 9; ++row) {
            if (this.indent) {
                JsonArrayFormatter.appendIndent(2, sb);
            }
            sb.append("[");
            for (int column = 0; column < 9; ++column) {
                byte val = matrix.get(row, column);
                String str = val == 0 ? this.getUnknownCellContentCharacter() : Integer.toString(val);
                if (column != 0) {
                    if (this.indent) {
                        sb.append(", ");
                    } else {
                        sb.append(",");
                    }
                }
                sb.append(str);
            }
            sb.append("]");
            if (row != 8) {
                sb.append(",");
            }
            if (!this.indent) continue;
            sb.append(this.getLineSeparator());
        }
        if (this.indent) {
            JsonArrayFormatter.appendIndent(1, sb);
        }
        sb.append("]");
        if (this.indent) {
            sb.append(this.getLineSeparator());
        }
        ++this.count;
        return sb.toString();
    }

    public void setIndent(boolean set) {
        this.indent = set;
    }

    @Override
    public String documentStart() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.indent) {
            sb.append(this.getLineSeparator());
        }
        this.count = 0;
        return sb.toString();
    }

    @Override
    public String documentEnd() {
        StringBuilder sb = new StringBuilder();
        sb.append("]");
        if (this.indent) {
            sb.append(this.getLineSeparator());
        }
        this.count = 0;
        return sb.toString();
    }
}

