/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.BitFreeMatrixInterface;
import de.sfuhrm.sudoku.CachedGameMatrixImpl;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameMatrixImpl;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.RiddleImpl;
import de.sfuhrm.sudoku.Solver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public final class Creator {
    private static final int CREATE_RIDDLE_RANDOM_CLEAR = 10;
    private final Function<GameMatrix, Boolean> resultConsumer;
    private final BitFreeMatrixInterface riddle = new CachedGameMatrixImpl();
    private GameMatrix winner;
    private final Random random = new Random();

    private Creator() {
        this.resultConsumer = t -> {
            this.winner = t;
            return true;
        };
    }

    protected static int getSetBitOffset(int mask, int bitIndex) {
        int count = 0;
        int workingMask = mask;
        int low = Integer.numberOfTrailingZeros(workingMask);
        assert (((workingMask >>>= low) & 1) == 1 || workingMask == 0);
        int i = low;
        while (workingMask != 0) {
            if ((workingMask & 1) != 0) {
                if (count == bitIndex) {
                    return i;
                }
                ++count;
            }
            workingMask >>>= 1;
            ++i;
        }
        return -1;
    }

    public static GameMatrix createFull() {
        Creator c = new Creator();
        c.riddle.clear();
        for (int i = 0; i < 3; ++i) {
            c.fillBlock(i * 3, i * 3);
        }
        boolean ok = c.backtrack(81 - c.riddle.getSetCount(), new int[2]);
        assert (ok);
        return c.winner;
    }

    public static GameMatrix createVariant(GameMatrix fullyFilled) {
        int offset;
        int distance;
        boolean swap;
        int i;
        GameMatrixImpl target = new GameMatrixImpl();
        Random random = new Random();
        byte[] substitution = Creator.createNumbersToDistribute(random, 1);
        for (int row = 0; row < 9; ++row) {
            for (int column = 0; column < 9; ++column) {
                byte original = fullyFilled.get(row, column);
                if (original == 0) {
                    throw new IllegalArgumentException("There are unset fields in the given GameMatrix");
                }
                byte substitute = substitution[original - 1];
                target.set(row, column, substitute);
            }
        }
        for (i = 0; i < 3; ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapRow(target, i * 3 + offset, i * 3 + offset + distance);
        }
        for (i = 0; i < 3; ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapColumn(target, i * 3 + offset, i * 3 + offset + distance);
        }
        return target;
    }

    protected static void swapRow(GameMatrix matrix, int rowA, int rowB) {
        for (int column = 0; column < 9; ++column) {
            byte av = matrix.get(rowA, column);
            byte bv = matrix.get(rowB, column);
            matrix.set(rowB, column, av);
            matrix.set(rowA, column, bv);
        }
    }

    protected static void swapColumn(GameMatrix matrix, int columnA, int columnB) {
        for (int row = 0; row < 9; ++row) {
            byte av = matrix.get(row, columnA);
            byte bv = matrix.get(row, columnB);
            matrix.set(row, columnB, av);
            matrix.set(row, columnA, bv);
        }
    }

    protected static byte[] createNumbersToDistribute(Random r, int multiplicity) {
        int totalNumbers = 9;
        ArrayList<Integer> numbersToDistribute = new ArrayList<Integer>(totalNumbers * multiplicity);
        for (int number = 1; number <= 9; ++number) {
            for (int j = 0; j < multiplicity; ++j) {
                numbersToDistribute.add(number);
            }
        }
        Collections.shuffle(numbersToDistribute, r);
        byte[] numbersToDistributeArray = new byte[numbersToDistribute.size()];
        int k = 0;
        for (Integer number : numbersToDistribute) {
            numbersToDistributeArray[k++] = number.byteValue();
        }
        return numbersToDistributeArray;
    }

    private static boolean canClear(BitFreeMatrixInterface riddle, int row, int column) {
        assert (riddle.get(row, column) != 0);
        int freeMask = riddle.getFreeMask(row, column);
        int freeVals = Integer.bitCount(freeMask);
        if (freeVals == 0) {
            return true;
        }
        byte old = riddle.get(row, column);
        riddle.set(row, column, (byte)0);
        Solver s = new Solver(riddle);
        s.setLimit(2);
        List<GameMatrix> results = s.solve();
        boolean result = results.size() == 1;
        riddle.set(row, column, old);
        return result;
    }

    public static Riddle createRiddle(GameMatrix fullMatrix) {
        int j;
        int i;
        Random random = new Random();
        RiddleImpl cur = new RiddleImpl();
        cur.setAll(fullMatrix.getArray());
        int multi = 0;
        while (multi < 10) {
            i = random.nextInt(9);
            j = random.nextInt(9);
            if (cur.get(j, i) == 0) continue;
            if (Creator.canClear(cur, j, i)) {
                cur.set(j, i, (byte)0);
                continue;
            }
            ++multi;
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                if (0 == cur.get(j, i) || !Creator.canClear(cur, j, i)) continue;
                cur.set(j, i, (byte)0);
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                cur.setWritable(j, i, cur.get(j, i) == 0);
            }
        }
        return cur;
    }

    private void fillBlock(int row, int column) {
        assert (GameMatrix.validCoords(row, column));
        assert (row % 3 == 0);
        assert (column % 3 == 0);
        byte[] numbers = Creator.createNumbersToDistribute(this.random, 1);
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.riddle.set(row + j, column + i, numbers[k++]);
            }
        }
    }

    private boolean backtrack(int numbersToDistribute, int[] minimumCell) {
        if (numbersToDistribute == 0) {
            assert (this.riddle.isValid()) : "Riddle went non-valid while backtracking";
            return this.resultConsumer.apply(this.riddle);
        }
        boolean hasMinimum = this.riddle.findLeastFreeCell(minimumCell);
        if (!hasMinimum) {
            return false;
        }
        int minimumRow = minimumCell[0];
        int minimumColumn = minimumCell[1];
        int minimumFree = this.riddle.getFreeMask(minimumRow, minimumColumn);
        int minimumBits = Integer.bitCount(minimumFree);
        for (int bit = 0; bit < minimumBits; ++bit) {
            int number = Creator.getSetBitOffset(minimumFree, bit);
            assert (number >= 1 && number <= 9);
            this.riddle.set(minimumRow, minimumColumn, (byte)number);
            boolean ok = this.backtrack(numbersToDistribute - 1, minimumCell);
            if (!ok) continue;
            return true;
        }
        this.riddle.set(minimumRow, minimumColumn, (byte)0);
        return false;
    }
}

