/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.BitFreeMatrixInterface;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.QuadraticArrays;
import java.util.Arrays;

class GameMatrixImpl
implements Cloneable,
BitFreeMatrixInterface {
    private byte[][] data = new byte[9][9];

    GameMatrixImpl() {
    }

    @Override
    public final void setAll(byte[][] initializationData) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, initializationData[j][i]);
            }
        }
    }

    protected final void row(int index, byte[] target) {
        assert (target.length == 9);
        System.arraycopy(this.data[index], 0, target, 0, 9);
    }

    protected final void column(int index, byte[] target) {
        assert (target.length == 9);
        for (int i = 0; i < 9; ++i) {
            target[i] = this.data[i][index];
        }
    }

    protected final void block(int row, int column, byte[] target) {
        assert (target.length == 9);
        assert (GameMatrix.validCoords(row, column));
        int k = 0;
        int roundRow = GameMatrixImpl.roundToBlock(row);
        int roundColumn = GameMatrixImpl.roundToBlock(column);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                target[k++] = this.data[roundRow + i][roundColumn + j];
            }
        }
    }

    @Override
    public final void clear() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, (byte)0);
            }
        }
    }

    @Override
    public final byte get(int row, int column) {
        assert (GameMatrix.validCoords(row, column));
        return this.data[row][column];
    }

    @Override
    public void set(int row, int column, byte value) {
        assert (GameMatrix.validCoords(row, column));
        assert (GameMatrix.validValue(value)) : "Value out of range: " + value;
        this.data[row][column] = value;
    }

    @Override
    public int getSetCount() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                assert (GameMatrix.validValue(this.data[i][j]));
                if (this.data[i][j] == 0) continue;
                ++count;
            }
        }
        assert (count >= 0 && count <= 81);
        return count;
    }

    @Override
    public final byte[][] getArray() {
        return QuadraticArrays.cloneArray(this.data);
    }

    public final String toString() {
        return QuadraticArrays.toString(this);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameMatrixImpl)) {
            return false;
        }
        GameMatrixImpl other = (GameMatrixImpl)obj;
        return Arrays.deepEquals((Object[])this.data, (Object[])other.data);
    }

    public Object clone() {
        GameMatrixImpl clone;
        try {
            clone = (GameMatrixImpl)super.clone();
            clone.data = QuadraticArrays.cloneArray(this.data);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
        return clone;
    }

    protected static int findDuplicateBits(byte[] data) {
        int currentMask = 0;
        int duplicates = 0;
        for (int i = 0; i < data.length; ++i) {
            int shifted = 1 << data[i];
            duplicates |= currentMask & shifted;
            currentMask |= shifted;
        }
        return duplicates & 0xFFFFFFFE;
    }

    protected static int getNumberMask(byte[] data) {
        int currentMask = 0;
        for (int i = 0; i < data.length; ++i) {
            currentMask |= 1 << data[i];
        }
        return currentMask & 0xFFFFFFFE;
    }

    @Override
    public final boolean isValid() {
        int i;
        boolean result = true;
        byte[] tmpData = new byte[9];
        for (i = 0; i < 9 && result; result &= GameMatrixImpl.findDuplicateBits(tmpData) == 0, ++i) {
            this.row(i, tmpData);
        }
        for (i = 0; i < 9 && result; result &= GameMatrixImpl.findDuplicateBits(tmpData) == 0, ++i) {
            this.column(i, tmpData);
        }
        for (i = 0; i < 9 && result; i += 3) {
            for (int j = 0; j < 9 && result; result &= GameMatrixImpl.findDuplicateBits(tmpData) == 0, j += 3) {
                this.block(i, j, tmpData);
            }
        }
        return result;
    }

    protected int getRowFreeMask(int row) {
        byte[] tmpData = new byte[9];
        this.row(row, tmpData);
        return ~GameMatrixImpl.getNumberMask(tmpData) & 0x3FE;
    }

    protected int getColumnFreeMask(int column) {
        byte[] tmpData = new byte[9];
        this.column(column, tmpData);
        return ~GameMatrixImpl.getNumberMask(tmpData) & 0x3FE;
    }

    protected int getBlockFreeMask(int row, int column) {
        byte[] tmpData = new byte[9];
        this.block(row, column, tmpData);
        return ~GameMatrixImpl.getNumberMask(tmpData) & 0x3FE;
    }

    @Override
    public int getFreeMask(int row, int column) {
        int free = 1022;
        assert (GameMatrix.validCoords(row, column));
        free &= this.getRowFreeMask(row);
        free &= this.getColumnFreeMask(column);
        return free &= this.getBlockFreeMask(row, column);
    }

    @Override
    public final boolean canSet(int row, int column, byte value) {
        assert (GameMatrix.validCoords(row, column));
        assert (GameMatrix.validValue(value));
        if (value == 0) {
            return true;
        }
        int free = this.getFreeMask(row, column);
        return (free & 1 << value) != 0;
    }

    protected static int roundToBlock(int in) {
        return in - in % 3;
    }
}

