/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.BitFreeMatrixInterface;
import de.sfuhrm.sudoku.CachedGameMatrixImpl;
import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameMatrixImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Solver {
    private final BitFreeMatrixInterface riddle;
    private final List<GameMatrix> possibleSolutions;
    public static final int LIMIT = 20;
    private int limit;

    public Solver(GameMatrix solveMe) {
        Objects.requireNonNull(solveMe, "solveMe is null");
        this.limit = 20;
        this.riddle = new CachedGameMatrixImpl();
        this.riddle.setAll(solveMe.getArray());
        this.possibleSolutions = new ArrayList<GameMatrix>();
    }

    public void setLimit(int set) {
        this.limit = set;
    }

    public List<GameMatrix> solve() {
        this.possibleSolutions.clear();
        int freeCells = 81 - this.riddle.getSetCount();
        this.backtrack(freeCells, new int[2]);
        return Collections.unmodifiableList(this.possibleSolutions);
    }

    private int backtrack(int freeCells, int[] minimumCell) {
        assert (freeCells >= 0) : "freeCells is negative";
        if (this.possibleSolutions.size() >= this.limit) {
            return 0;
        }
        if (freeCells == 0) {
            if (this.possibleSolutions.size() < this.limit) {
                GameMatrixImpl gmi = new GameMatrixImpl();
                gmi.setAll(this.riddle.getArray());
                this.possibleSolutions.add(gmi);
            }
            return 1;
        }
        boolean hasMin = this.riddle.findLeastFreeCell(minimumCell);
        if (!hasMin) {
            return 0;
        }
        int result = 0;
        int minimumRow = minimumCell[0];
        int minimumColumn = minimumCell[1];
        int minimumFree = this.riddle.getFreeMask(minimumRow, minimumColumn);
        int minimumBits = Integer.bitCount(minimumFree);
        for (int bit = 0; bit < minimumBits; ++bit) {
            int index = Creator.getSetBitOffset(minimumFree, bit);
            assert (index > 0);
            this.riddle.set(minimumRow, minimumColumn, (byte)index);
            int resultCount = this.backtrack(freeCells - 1, minimumCell);
            result += resultCount;
        }
        this.riddle.set(minimumRow, minimumColumn, (byte)0);
        return result;
    }
}

