/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameMatrix;

public final class QuadraticArrays {
    private QuadraticArrays() {
    }

    static int[][] cloneArray(int[][] array) {
        int[][] result = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new int[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static byte[][] cloneArray(byte[][] array) {
        byte[][] result = new byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new byte[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static boolean[][] cloneArray(boolean[][] array) {
        boolean[][] result = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new boolean[array[i].length];
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    public static byte[][] parse(String ... rows) {
        if (rows.length != 9) {
            throw new IllegalArgumentException("Array must have 9 elements");
        }
        byte[][] result = new byte[9][9];
        for (int r = 0; r < rows.length; ++r) {
            if (rows[r].length() != 9) {
                throw new IllegalArgumentException("Row " + r + " must have " + 9 + " elements: " + rows[r]);
            }
            for (int c = 0; c < 9; ++c) {
                char v = rows[r].charAt(c);
                result[r][c] = v >= '0' && v <= '9' ? (byte)(v - 48) : (byte)0;
            }
        }
        return result;
    }

    static String toString(GameMatrix gameMatrix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                byte v = gameMatrix.get(i, j);
                assert (GameMatrix.validValue(v));
                if (v != 0) {
                    sb.append(Integer.toString(v));
                    continue;
                }
                sb.append('_');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

