/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import java.util.Arrays;

public class GameMatrix
implements Cloneable {
    protected static final int MASK_FOR_NINE_BITS = 1022;
    private byte[][] data = new byte[9][9];
    public static final byte UNSET = 0;
    protected static final byte MINIMUM_VALUE = 1;
    protected static final byte MAXIMUM_VALUE = 9;
    public static final int SIZE = 9;
    public static final int TOTAL_FIELDS = 81;
    public static final int BLOCK_SIZE = 3;
    protected static final int BLOCK_COUNT = 3;

    public final void setAll(byte[][] initializationData) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, initializationData[j][i]);
            }
        }
    }

    protected final void row(int index, byte[] target) {
        System.arraycopy(this.data[index], 0, target, 0, 9);
    }

    protected final void column(int index, byte[] target) {
        for (int i = 0; i < 9; ++i) {
            target[i] = this.data[i][index];
        }
    }

    protected final void block(int row, int column, byte[] target) {
        int k = 0;
        int roundRow = GameMatrix.roundToBlock(row);
        int roundColumn = GameMatrix.roundToBlock(column);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                target[k++] = this.data[roundRow + i][roundColumn + j];
            }
        }
    }

    public static byte[][] parse(String ... rows) {
        if (rows.length != 9) {
            throw new IllegalArgumentException("Array must have 9 elements");
        }
        byte[][] result = new byte[9][9];
        for (int r = 0; r < rows.length; ++r) {
            if (rows[r].length() != 9) {
                throw new IllegalArgumentException("Row " + r + " must have " + 9 + " elements: " + rows[r]);
            }
            for (int c = 0; c < 9; ++c) {
                char v = rows[r].charAt(c);
                result[r][c] = v >= '0' && v <= '9' ? (byte)(v - 48) : (byte)0;
            }
        }
        return result;
    }

    public final void clear() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, (byte)0);
            }
        }
    }

    public final byte get(int row, int column) {
        return this.data[row][column];
    }

    public void set(int row, int column, byte value) {
        this.data[row][column] = value;
    }

    public int getSetCount() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.data[i][j] == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public final byte[][] getArray() {
        return GameMatrix.cloneArray(this.data);
    }

    protected static int[][] cloneArray(int[][] array) {
        int[][] result = new int[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    protected static byte[][] cloneArray(byte[][] array) {
        byte[][] result = new byte[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    protected static boolean[][] cloneArray(boolean[][] array) {
        boolean[][] result = new boolean[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                byte v = this.get(i, j);
                if (v != 0) {
                    sb.append(Integer.toString(this.get(i, j)));
                    continue;
                }
                sb.append('_');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameMatrix)) {
            return false;
        }
        GameMatrix other = (GameMatrix)obj;
        return Arrays.deepEquals((Object[])this.data, (Object[])other.data);
    }

    public Object clone() {
        GameMatrix clone;
        try {
            clone = (GameMatrix)super.clone();
            clone.data = GameMatrix.cloneArray(this.data);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
        return clone;
    }

    protected static int findDuplicateBits(byte[] data) {
        int currentMask = 0;
        int duplicates = 0;
        for (int i = 0; i < data.length; ++i) {
            int shifted = 1 << data[i];
            duplicates |= currentMask & shifted;
            currentMask |= shifted;
        }
        return duplicates & 0xFFFFFFFE;
    }

    protected static int getNumberMask(byte[] data) {
        int currentMask = 0;
        for (int i = 0; i < data.length; ++i) {
            currentMask |= 1 << data[i];
        }
        return currentMask & 0xFFFFFFFE;
    }

    public final boolean isValid() {
        int i;
        boolean result = true;
        byte[] tmpData = new byte[9];
        for (i = 0; i < 9 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, ++i) {
            this.row(i, tmpData);
        }
        for (i = 0; i < 9 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, ++i) {
            this.column(i, tmpData);
        }
        for (i = 0; i < 9 && result; i += 3) {
            for (int j = 0; j < 9 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, j += 3) {
                this.block(i, j, tmpData);
            }
        }
        return result;
    }

    protected int getRowFreeMask(int row) {
        byte[] tmpData = new byte[9];
        this.row(row, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    protected int getColumnFreeMask(int column) {
        byte[] tmpData = new byte[9];
        this.column(column, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    protected int getBlockFreeMask(int row, int column) {
        byte[] tmpData = new byte[9];
        this.block(row, column, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    protected int getFreeMask(int row, int column) {
        int free = 1022;
        free &= this.getRowFreeMask(row);
        free &= this.getColumnFreeMask(column);
        return free &= this.getBlockFreeMask(row, column);
    }

    public final boolean canSet(int row, int column, byte value) {
        if (value == 0) {
            return true;
        }
        int free = this.getFreeMask(row, column);
        return (free & 1 << value) != 0;
    }

    protected static int roundToBlock(int in) {
        return in - in % 3;
    }

    protected final boolean findLeastFreeCell(int[] rowColumnResult) {
        int minimumBits = -1;
        int minimumRow = -1;
        int minimumColumn = -1;
        for (int row = 0; row < 9; ++row) {
            for (int column = 0; column < 9; ++column) {
                int free;
                int bits;
                if (this.get(row, column) != 0 || (bits = Integer.bitCount(free = this.getFreeMask(row, column))) == 0 || minimumBits != -1 && bits >= minimumBits) continue;
                minimumColumn = column;
                minimumRow = row;
                minimumBits = bits;
            }
            rowColumnResult[0] = minimumRow;
            rowColumnResult[1] = minimumColumn;
        }
        return minimumBits != -1;
    }
}

