/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.Riddle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Solver {
    private final Riddle riddle;
    private final List<Riddle> possibleSolutions;
    public static final int LIMIT = 20;

    public Solver(Riddle solveMe) {
        this.riddle = (Riddle)solveMe.clone();
        this.possibleSolutions = new ArrayList<Riddle>();
    }

    public List<Riddle> solve() {
        this.possibleSolutions.clear();
        int freeCells = 81 - this.riddle.getSetCount();
        this.backtrack(freeCells, new int[2]);
        return Collections.unmodifiableList(this.possibleSolutions);
    }

    private int backtrack(int freeCells, int[] minimumCell) {
        if (freeCells == 0) {
            if (this.possibleSolutions.size() < 20) {
                this.possibleSolutions.add((Riddle)this.riddle.clone());
            }
            return 1;
        }
        boolean hasMin = this.riddle.findLeastFreeCell(minimumCell);
        if (!hasMin) {
            return 0;
        }
        int result = 0;
        int minimumRow = minimumCell[0];
        int minimumColumn = minimumCell[1];
        int minimumFree = this.riddle.getFreeMask(minimumRow, minimumColumn);
        int minimumBits = Integer.bitCount(minimumFree);
        for (int bit = 0; bit < minimumBits; ++bit) {
            int index = Creator.getSetBitOffset(minimumFree, bit);
            if (index <= 0) {
                throw new IllegalStateException("minV=" + minimumFree + ", i=" + bit + ", idx=" + index);
            }
            this.riddle.set(minimumRow, minimumColumn, (byte)index);
            int resultCount = this.backtrack(freeCells - 1, minimumCell);
            result += resultCount;
        }
        this.riddle.set(minimumRow, minimumColumn, (byte)0);
        return result;
    }
}

