/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.GameMatrix;
import java.util.Arrays;

class CachedGameMatrix
extends GameMatrix
implements Cloneable {
    private int[] rowFree;
    private int[] columnFree;
    private int[][] blockFree = new int[3][3];
    private int setCount;

    CachedGameMatrix() {
        int i;
        this.rowFree = new int[9];
        this.columnFree = new int[9];
        for (i = 0; i < 9; ++i) {
            this.rowFree[i] = 1022;
            this.columnFree[i] = 1022;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.blockFree[i][j] = 1022;
            }
        }
    }

    @Override
    protected int getBlockFreeMask(int row, int column) {
        return this.blockFree[row / 3][column / 3];
    }

    @Override
    protected int getColumnFreeMask(int column) {
        return this.columnFree[column];
    }

    @Override
    protected int getRowFreeMask(int row) {
        return this.rowFree[row];
    }

    @Override
    public int getFreeMask(int row, int column) {
        return this.rowFree[row] & this.columnFree[column] & this.blockFree[row / 3][column / 3];
    }

    @Override
    public void set(int row, int column, byte value) {
        int bitMask;
        byte oldValue = super.get(row, column);
        if (oldValue != 0) {
            bitMask = 1 << oldValue;
            int n = row;
            this.rowFree[n] = this.rowFree[n] | bitMask;
            int n2 = column;
            this.columnFree[n2] = this.columnFree[n2] | bitMask;
            int[] nArray = this.blockFree[row / 3];
            int n3 = column / 3;
            nArray[n3] = nArray[n3] | bitMask;
            --this.setCount;
        }
        if (value != 0) {
            bitMask = ~(1 << value);
            int n = row;
            this.rowFree[n] = this.rowFree[n] & bitMask;
            int n4 = column;
            this.columnFree[n4] = this.columnFree[n4] & bitMask;
            int[] nArray = this.blockFree[row / 3];
            int n5 = column / 3;
            nArray[n5] = nArray[n5] & bitMask;
            ++this.setCount;
        }
        super.set(row, column, value);
    }

    @Override
    public int getSetCount() {
        return this.setCount;
    }

    @Override
    public Object clone() {
        CachedGameMatrix clone = (CachedGameMatrix)super.clone();
        clone.blockFree = CachedGameMatrix.cloneArray(this.blockFree);
        clone.columnFree = Arrays.copyOf(this.columnFree, this.columnFree.length);
        clone.rowFree = Arrays.copyOf(this.rowFree, this.rowFree.length);
        return clone;
    }
}

