/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class MarkdownTableFormatter
extends AbstractTextFormatter {
    private static final String TABLE_SEPARATOR = "|";

    @Override
    public String format(GameMatrix matrix) {
        int column;
        StringBuilder sb = new StringBuilder();
        for (column = 0; column < 9; ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(" ");
            sb.append(" ");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getLineSeparator());
        for (column = 0; column < 9; ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append("---");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getLineSeparator());
        for (int row = 0; row < 9; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                byte val = matrix.get(row, column2);
                String str = val == 0 ? this.getUnknownCellContentCharacter() : Integer.toString(val);
                if (column2 == 0) {
                    sb.append(TABLE_SEPARATOR);
                }
                sb.append(" ");
                sb.append(str);
                sb.append(" ");
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(this.getLineSeparator());
        }
        for (column = 0; column < 9; ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(" ");
            sb.append(" ");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getLineSeparator());
        return sb.toString();
    }
}

