/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class LatexTableFormatter
extends AbstractTextFormatter {
    private static final String TABLE_CELL_SEPARATOR = "&";

    public LatexTableFormatter() {
        this.setUnknownCellContentCharacter(" ");
    }

    @Override
    public String format(GameMatrix matrix) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\begin{center}");
        sb.append("\\huge");
        sb.append(this.getLineSeparator());
        sb.append("\\begin{tabular}{");
        for (int i = 0; i < 9; ++i) {
            if (i % 3 == 0 && i != 0) {
                sb.append("|");
            }
            sb.append("|C{1.1em}");
        }
        sb.append("|");
        sb.append("}");
        sb.append(this.getLineSeparator());
        for (int row = 0; row < 9; ++row) {
            if (row % 3 == 0) {
                sb.append("\\hline");
                sb.append(this.getLineSeparator());
            }
            for (int column = 0; column < 9; ++column) {
                byte val = matrix.get(row, column);
                String str = val == 0 ? this.getUnknownCellContentCharacter() : Integer.toString(val);
                if (column != 0) {
                    sb.append(TABLE_CELL_SEPARATOR);
                }
                sb.append(" ");
                sb.append(str);
                sb.append(" ");
            }
            sb.append("\\\\");
            sb.append(this.getLineSeparator());
            sb.append("\\hline");
            sb.append(this.getLineSeparator());
        }
        sb.append("\\end{tabular}");
        sb.append(this.getLineSeparator());
        sb.append("\\end{center}");
        sb.append(this.getLineSeparator());
        sb.append("\\vspace{25 mm}");
        sb.append(this.getLineSeparator());
        return sb.toString();
    }

    @Override
    public String documentStart() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\documentclass[a4paper,11pt]{article}");
        sb.append(this.getLineSeparator());
        sb.append("\\usepackage{array}");
        sb.append(this.getLineSeparator());
        sb.append("\\newcolumntype{L}[1]{>{\\raggedright\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getLineSeparator());
        sb.append("\\newcolumntype{C}[1]{>{\\centering\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getLineSeparator());
        sb.append("\\newcolumntype{R}[1]{>{\\raggedleft\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getLineSeparator());
        sb.append("\\begin{document}");
        sb.append(this.getLineSeparator());
        return sb.toString();
    }

    @Override
    public String documentEnd() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\end{document}");
        sb.append(this.getLineSeparator());
        return sb.toString();
    }
}

