/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.CachedGameMatrix;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.Solver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public final class Creator {
    private final Function<GameMatrix, Boolean> resultConsumer;
    private final GameMatrix riddle = new CachedGameMatrix();
    private GameMatrix winner;
    private final Random random = new Random();
    private static final int INTEGER_BITS = 32;
    private static final int CREATE_RIDDLE_RANDOM_CLEAR = 10;

    private Creator() {
        this.resultConsumer = t -> {
            this.winner = t;
            return true;
        };
    }

    protected static int getSetBitOffset(int mask, int bitIndex) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (count == bitIndex) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public static GameMatrix createFull() {
        int fields;
        boolean ok;
        Creator c = new Creator();
        do {
            c.riddle.clear();
            for (int i = 0; i < 3; ++i) {
                c.fillBlock(i * 3, i * 3);
            }
        } while (!(ok = c.backtrack((fields = 81) - c.riddle.getSetCount(), new int[2])));
        return c.winner;
    }

    public static GameMatrix createVariant(GameMatrix matrix) {
        int offset;
        int distance;
        boolean swap;
        int i;
        GameMatrix target = new GameMatrix();
        Random random = new Random();
        byte[] substitution = Creator.createNumbersToDistribute(random, 1);
        for (int row = 0; row < 9; ++row) {
            for (int column = 0; column < 9; ++column) {
                byte original = matrix.get(row, column);
                if (original == 0) {
                    throw new IllegalArgumentException("There are unset fields in the given GameMatrix");
                }
                byte substitute = substitution[original - 1];
                target.set(row, column, substitute);
            }
        }
        for (i = 0; i < 3; ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapRow(matrix, i * 3 + offset, i * 3 + offset + distance);
        }
        for (i = 0; i < 3; ++i) {
            swap = random.nextBoolean();
            if (!swap) continue;
            distance = 1 + random.nextInt(2);
            offset = 0;
            if (distance != 2) {
                offset = random.nextInt(2);
            }
            Creator.swapColumn(matrix, i * 3 + offset, i * 3 + offset + distance);
        }
        return target;
    }

    protected static void swapRow(GameMatrix matrix, int rowA, int rowB) {
        for (int column = 0; column < 9; ++column) {
            byte av = matrix.get(rowA, column);
            byte bv = matrix.get(rowB, column);
            matrix.set(rowB, column, av);
            matrix.set(rowA, column, bv);
        }
    }

    protected static void swapColumn(GameMatrix matrix, int columnA, int columnB) {
        for (int row = 0; row < 9; ++row) {
            byte av = matrix.get(row, columnA);
            byte bv = matrix.get(row, columnB);
            matrix.set(row, columnB, av);
            matrix.set(row, columnA, bv);
        }
    }

    protected static byte[] createNumbersToDistribute(Random r, int multiplicity) {
        int totalNumbers = 9;
        ArrayList<Integer> numbersToDistribute = new ArrayList<Integer>(totalNumbers * multiplicity);
        for (int number = 1; number <= 9; ++number) {
            for (int j = 0; j < multiplicity; ++j) {
                numbersToDistribute.add(number);
            }
        }
        Collections.shuffle(numbersToDistribute, r);
        byte[] numbersToDistributeArray = new byte[numbersToDistribute.size()];
        int k = 0;
        for (Integer number : numbersToDistribute) {
            numbersToDistributeArray[k++] = number.byteValue();
        }
        return numbersToDistributeArray;
    }

    private static boolean canClear(Riddle riddle, int column, int row) {
        if (riddle.get(row, column) == 0) {
            return false;
        }
        int freeMask = riddle.getFreeMask(row, column);
        int freeVals = Integer.bitCount(freeMask);
        if (freeVals == 0) {
            return true;
        }
        byte old = riddle.get(row, column);
        riddle.set(row, column, (byte)0);
        Solver s = new Solver(riddle);
        List<Riddle> results = s.solve();
        boolean result = results.size() == 1;
        riddle.set(row, column, old);
        return result;
    }

    public static Riddle createRiddle(GameMatrix in) {
        int j;
        int i;
        Random random = new Random();
        Riddle cur = new Riddle();
        cur.setAll(in.getArray());
        int multi = 0;
        while (multi < 10) {
            i = random.nextInt(9);
            j = random.nextInt(9);
            if (cur.get(j, i) == 0) continue;
            if (Creator.canClear(cur, i, j)) {
                cur.set(j, i, (byte)0);
                continue;
            }
            ++multi;
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                if (cur.get(j, i) == 0 || !Creator.canClear(cur, i, j)) continue;
                cur.set(j, i, (byte)0);
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                cur.setWritable(j, i, cur.get(j, i) == 0);
            }
        }
        return cur;
    }

    private void fillBlock(int row, int column) {
        byte[] numbers = Creator.createNumbersToDistribute(this.random, 1);
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.riddle.set(row + j, column + i, numbers[k++]);
            }
        }
    }

    private boolean backtrack(int numbersToDistribute, int[] minimumCell) {
        if (numbersToDistribute == 0) {
            if (!this.riddle.isValid()) {
                throw new IllegalStateException();
            }
            return this.resultConsumer.apply(this.riddle);
        }
        boolean hasMinimum = this.riddle.findLeastFreeCell(minimumCell);
        if (!hasMinimum) {
            return false;
        }
        int minimumRow = minimumCell[0];
        int minimumColumn = minimumCell[1];
        int minimumFree = this.riddle.getFreeMask(minimumRow, minimumColumn);
        int minimumBits = Integer.bitCount(minimumFree);
        for (int bit = 0; bit < minimumBits; ++bit) {
            int free = this.riddle.getFreeMask(minimumRow, minimumColumn);
            int number = Creator.getSetBitOffset(free, bit);
            if (number <= 0) {
                throw new IllegalStateException();
            }
            this.riddle.set(minimumRow, minimumColumn, (byte)number);
            boolean ok = this.backtrack(numbersToDistribute - 1, minimumCell);
            if (ok) {
                return true;
            }
            this.riddle.set(minimumRow, minimumColumn, (byte)0);
        }
        return false;
    }
}

