/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.Riddle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Solver {
    private final Riddle riddle;
    private final List<Riddle> possibleSolutions;
    public static final int LIMIT = 20;

    public Solver(Riddle solveMe) {
        this.riddle = (Riddle)solveMe.clone();
        this.possibleSolutions = new ArrayList<Riddle>();
    }

    public List<Riddle> solve() {
        this.possibleSolutions.clear();
        int freeCells = 81 - this.riddle.getSetCount();
        this.backtrack(freeCells);
        return Collections.unmodifiableList(this.possibleSolutions);
    }

    private int backtrack(int freeCells) {
        if (freeCells == 0) {
            if (this.possibleSolutions.size() < 20) {
                this.possibleSolutions.add((Riddle)this.riddle.clone());
            }
            return 1;
        }
        boolean hasMin = false;
        int result = 0;
        int minColumn = 0;
        int minRow = 0;
        int minFreeMask = 0;
        int minBits = 0;
        for (int i = 0; !(i >= 9 || hasMin && minBits == 1); ++i) {
            for (int j = 0; !(j >= 9 || hasMin && minBits == 1); ++j) {
                if (this.riddle.get(j, i) != 0) continue;
                int free = this.riddle.getFreeMask(j, i);
                if (free == 0) {
                    return 0;
                }
                int bits = Integer.bitCount(free);
                if (hasMin && bits >= minBits) continue;
                minFreeMask = free;
                minColumn = i;
                minRow = j;
                minBits = bits;
                hasMin = true;
            }
        }
        if (hasMin) {
            for (int bit = 0; bit < minBits; ++bit) {
                int index = Creator.getSetBitOffset(minFreeMask, bit);
                if (index < 0) {
                    throw new IllegalStateException("minV=" + minFreeMask + ", i=" + bit + ", idx=" + index);
                }
                this.riddle.set(minRow, minColumn, (byte)index);
                int resultCount = this.backtrack(freeCells - 1);
                result += resultCount;
            }
            this.riddle.set(minRow, minColumn, (byte)0);
        } else {
            result = 0;
        }
        return result;
    }
}

