/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import java.util.Arrays;

public class GameMatrix
implements Cloneable {
    static final int MASK_FOR_NINE_BITS = 1022;
    private byte[][] data = new byte[9][9];
    public static final byte UNSET = 0;
    public static final int SIZE = 9;
    protected static final int BLOCK_SIZE = 3;

    public final void setAll(byte[][] initializationData) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, initializationData[j][i]);
            }
        }
    }

    protected void row(int index, byte[] target) {
        System.arraycopy(this.data[index], 0, target, 0, 9);
    }

    protected void column(int index, byte[] target) {
        for (int i = 0; i < 9; ++i) {
            target[i] = this.data[i][index];
        }
    }

    protected void block(int row, int column, byte[] target) {
        int k = 0;
        row = GameMatrix.roundToBlock(row);
        column = GameMatrix.roundToBlock(column);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                target[k++] = this.data[row + i][column + j];
            }
        }
    }

    public static final byte[][] parse(String ... rows) {
        if (rows.length != 9) {
            throw new IllegalArgumentException("Array must have 9 elements");
        }
        byte[][] result = new byte[9][9];
        for (int r = 0; r < rows.length; ++r) {
            if (rows[r].length() != 9) {
                throw new IllegalArgumentException("Row " + r + " must have " + 9 + " elements: " + rows[r]);
            }
            for (int c = 0; c < 9; ++c) {
                char v = rows[r].charAt(c);
                result[r][c] = v >= '0' && v <= '9' ? (byte)(v - 48) : (byte)0;
            }
        }
        return result;
    }

    public void clear() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.set(j, i, (byte)0);
            }
        }
    }

    public final byte get(int row, int column) {
        return this.data[row][column];
    }

    public void set(int row, int column, byte value) {
        this.data[row][column] = value;
    }

    public int getSetCount() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                count += this.data[i][j] != 0 ? 1 : 0;
            }
        }
        return count;
    }

    public byte[][] getArray() {
        return GameMatrix.cloneArray(this.data);
    }

    static int[][] cloneArray(int[][] array) {
        int[][] result = new int[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static byte[][] cloneArray(byte[][] array) {
        byte[][] result = new byte[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    static boolean[][] cloneArray(boolean[][] array) {
        boolean[][] result = new boolean[9][9];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                byte v = this.get(i, j);
                if (v != 0) {
                    sb.append(Integer.toString(this.get(i, j)));
                    continue;
                }
                sb.append('_');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.deepHashCode((Object[])this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameMatrix)) {
            return false;
        }
        GameMatrix other = (GameMatrix)obj;
        return Arrays.deepEquals((Object[])this.data, (Object[])other.data);
    }

    public Object clone() {
        GameMatrix clone;
        try {
            clone = (GameMatrix)super.clone();
            clone.data = GameMatrix.cloneArray(this.data);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
        return clone;
    }

    static int findDuplicateBits(byte[] data) {
        int currentMask = 0;
        int duplicates = 0;
        for (int i = 0; i < data.length; ++i) {
            int shifted = 1 << data[i];
            duplicates |= currentMask & shifted;
            currentMask |= shifted;
        }
        return duplicates & 0xFFFFFFFE;
    }

    static int getNumberMask(byte[] data) {
        int currentMask = 0;
        for (int i = 0; i < data.length; ++i) {
            currentMask |= 1 << data[i];
        }
        return currentMask & 0xFFFFFFFE;
    }

    public final boolean isValid() {
        int i;
        boolean result = true;
        byte[] tmpData = new byte[9];
        for (i = 0; i < 9 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, ++i) {
            this.row(i, tmpData);
        }
        for (i = 0; i < 9 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, ++i) {
            this.column(i, tmpData);
        }
        for (i = 0; i < 3 && result; ++i) {
            for (int j = 0; j < 3 && result; result &= GameMatrix.findDuplicateBits(tmpData) == 0, ++j) {
                this.block(i, j, tmpData);
            }
        }
        return result;
    }

    int getRowFreeMask(int row) {
        byte[] tmpData = new byte[9];
        this.row(row, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    int getColumnFreeMask(int column) {
        byte[] tmpData = new byte[9];
        this.column(column, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    int getBlockFreeMask(int row, int column) {
        byte[] tmpData = new byte[9];
        this.block(row, column, tmpData);
        return ~GameMatrix.getNumberMask(tmpData) & 0x3FE;
    }

    int getFreeMask(int row, int column) {
        int free = 1022;
        free &= this.getRowFreeMask(row);
        free &= this.getColumnFreeMask(column);
        return free &= this.getBlockFreeMask(row, column);
    }

    public final boolean canSet(int row, int column, byte value) {
        if (value == 0) {
            return true;
        }
        int free = this.getFreeMask(row, column);
        return (free & 1 << value) != 0;
    }

    static int roundToBlock(int in) {
        return in - in % 3;
    }
}

