/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku;

import de.sfuhrm.sudoku.CachedGameMatrix;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.Solver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class Creator {
    private final Function<GameMatrix, Boolean> resultConsumer;
    private final GameMatrix riddle = new CachedGameMatrix();
    private GameMatrix winner;
    private final Random random = new Random();

    private Creator() {
        this.resultConsumer = t -> {
            this.winner = t;
            return true;
        };
    }

    static final int getSetBitOffset(int mask, int bitIndex) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (count == bitIndex) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public static GameMatrix createFull() {
        boolean ok;
        Creator c = new Creator();
        do {
            c.riddle.clear();
            c.fillBlock(0, 0);
            c.fillBlock(3, 3);
            c.fillBlock(6, 6);
        } while (!(ok = c.backtrack(81 - c.riddle.getSetCount())));
        return c.winner;
    }

    static byte[] createNumbersToDistribute(Random r, int multiplicity) {
        ArrayList<Integer> numbersToDistribute = new ArrayList<Integer>(9 * multiplicity);
        for (int number = 1; number <= 9; ++number) {
            for (int j = 0; j < multiplicity; ++j) {
                numbersToDistribute.add(number);
            }
        }
        Collections.shuffle(numbersToDistribute, r);
        byte[] numbersToDistributeArray = new byte[numbersToDistribute.size()];
        int k = 0;
        for (Integer number : numbersToDistribute) {
            numbersToDistributeArray[k++] = number.byteValue();
        }
        return numbersToDistributeArray;
    }

    private static boolean canClear(Riddle riddle, int column, int row) {
        if (riddle.get(row, column) == 0) {
            return false;
        }
        int freeMask = riddle.getFreeMask(row, column);
        int freeVals = Integer.bitCount(freeMask);
        if (freeVals == 0) {
            return true;
        }
        byte old = riddle.get(row, column);
        riddle.set(row, column, (byte)0);
        Solver s = new Solver(riddle);
        List<Riddle> results = s.solve();
        boolean result = results.size() == 1;
        riddle.set(row, column, old);
        return result;
    }

    public static Riddle createRiddle(GameMatrix in) {
        int j;
        int i;
        Random random = new Random();
        Riddle cur = new Riddle();
        cur.setAll(in.getArray());
        int multi = 0;
        while (multi < 10) {
            i = random.nextInt(9);
            j = random.nextInt(9);
            if (cur.get(j, i) == 0) continue;
            if (Creator.canClear(cur, i, j)) {
                cur.set(j, i, (byte)0);
                continue;
            }
            ++multi;
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                if (cur.get(j, i) == 0 || !Creator.canClear(cur, i, j)) continue;
                cur.set(j, i, (byte)0);
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                cur.setWritable(j, i, cur.get(j, i) == 0);
            }
        }
        return cur;
    }

    private void fillBlock(int row, int column) {
        byte[] numbers = Creator.createNumbersToDistribute(this.random, 1);
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.riddle.set(row + j, column + i, numbers[k++]);
            }
        }
    }

    private boolean backtrack(int numbersToDistribute) {
        if (numbersToDistribute == 0) {
            if (!this.riddle.isValid()) {
                throw new IllegalStateException();
            }
            return this.resultConsumer.apply(this.riddle);
        }
        int minimumColumn = -1;
        int minimumRow = -1;
        int minimumBits = -1;
        for (int row = 0; row < 9; ++row) {
            for (int column = 0; column < 9; ++column) {
                int free;
                int bits;
                if (this.riddle.get(row, column) != 0 || (bits = Integer.bitCount(free = this.riddle.getFreeMask(row, column))) == 0 || minimumBits != -1 && bits >= minimumBits) continue;
                minimumColumn = column;
                minimumRow = row;
                minimumBits = bits;
            }
        }
        if (minimumColumn == -1 || minimumRow == -1) {
            return false;
        }
        for (int bit = 0; bit < minimumBits; ++bit) {
            int free = this.riddle.getFreeMask(minimumRow, minimumColumn);
            int number = Creator.getSetBitOffset(free, bit);
            if (number <= 0) {
                throw new IllegalStateException();
            }
            this.riddle.set(minimumRow, minimumColumn, (byte)number);
            boolean ok = this.backtrack(numbersToDistribute - 1);
            if (ok) {
                return true;
            }
            this.riddle.set(minimumRow, minimumColumn, (byte)0);
        }
        return false;
    }
}

