/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class MarkdownTableFormatter
extends AbstractTextFormatter {
    private static final String TABLE_SEPARATOR = "|";

    @Override
    public String format(GameMatrix matrix) {
        int column;
        StringBuilder sb = new StringBuilder();
        GameSchema schema = matrix.getSchema();
        for (column = 0; column < schema.getWidth(); ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(" ");
            sb.append(" ");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getRowSeparator());
        for (column = 0; column < schema.getWidth(); ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append("---");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getRowSeparator());
        for (int row = 0; row < schema.getWidth(); ++row) {
            for (int column2 = 0; column2 < schema.getWidth(); ++column2) {
                byte val = matrix.get(row, column2);
                String str = val == schema.getUnsetValue() ? this.getUnknownCellContentCharacter() : Integer.toString(val + 1 - schema.getMinimumValue());
                if (column2 == 0) {
                    sb.append(TABLE_SEPARATOR);
                }
                sb.append(" ");
                sb.append(str);
                sb.append(" ");
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(this.getRowSeparator());
        }
        for (column = 0; column < schema.getWidth(); ++column) {
            if (column == 0) {
                sb.append(TABLE_SEPARATOR);
            }
            sb.append(" ");
            sb.append(" ");
            sb.append(TABLE_SEPARATOR);
        }
        sb.append(this.getRowSeparator());
        return sb.toString();
    }
}

