/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class PlainTextFormatter
extends AbstractTextFormatter {
    @Override
    public String format(GameMatrix matrix) {
        StringBuilder sb = new StringBuilder();
        GameSchema schema = matrix.getSchema();
        for (int row = 0; row < schema.getWidth(); ++row) {
            for (int column = 0; column < schema.getWidth(); ++column) {
                byte val = matrix.get(row, column);
                String str = val == schema.getUnsetValue() ? this.getUnknownCellContentCharacter() : Integer.toString(val + 1 - schema.getMinimumValue());
                sb.append(str);
                if (column >= schema.getWidth() - 1) continue;
                sb.append(this.getColumnSeparator());
            }
            sb.append(this.getRowSeparator());
        }
        return sb.toString();
    }
}

