/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class LatexTableFormatter
extends AbstractTextFormatter {
    private static final String TABLE_CELL_SEPARATOR = "&";

    public LatexTableFormatter() {
        this.setUnknownCellContentCharacter(" ");
    }

    @Override
    public String format(GameMatrix matrix) {
        StringBuilder sb = new StringBuilder();
        GameSchema schema = matrix.getSchema();
        sb.append("\\begin{center}");
        sb.append("\\huge");
        sb.append(this.getRowSeparator());
        sb.append("\\begin{tabular}{");
        for (int i = 0; i < schema.getWidth(); ++i) {
            if (i % schema.getBlockWidth() == 0 && i != 0) {
                sb.append("|");
            }
            sb.append("|C{1.1em}");
        }
        sb.append("|");
        sb.append("}");
        sb.append(this.getRowSeparator());
        for (int row = 0; row < schema.getWidth(); ++row) {
            if (row % schema.getBlockWidth() == 0) {
                sb.append("\\hline");
                sb.append(this.getRowSeparator());
            }
            for (int column = 0; column < schema.getWidth(); ++column) {
                byte val = matrix.get(row, column);
                String str = val == schema.getUnsetValue() ? this.getUnknownCellContentCharacter() : Integer.toString(val);
                if (column != 0) {
                    sb.append(TABLE_CELL_SEPARATOR);
                }
                sb.append(" ");
                sb.append(str);
                sb.append(" ");
            }
            sb.append("\\\\");
            sb.append(this.getRowSeparator());
            sb.append("\\hline");
            sb.append(this.getRowSeparator());
        }
        sb.append("\\end{tabular}");
        sb.append(this.getRowSeparator());
        sb.append("\\end{center}");
        sb.append(this.getRowSeparator());
        sb.append("\\vspace{25 mm}");
        sb.append(this.getRowSeparator());
        return sb.toString();
    }

    @Override
    public String documentStart() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\documentclass[a4paper,11pt]{article}");
        sb.append(this.getRowSeparator());
        sb.append("\\usepackage{array}");
        sb.append(this.getRowSeparator());
        sb.append("\\newcolumntype{L}[1]{>{\\raggedright\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getRowSeparator());
        sb.append("\\newcolumntype{C}[1]{>{\\centering\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getRowSeparator());
        sb.append("\\newcolumntype{R}[1]{>{\\raggedleft\\let\\newline\\\\\\arraybackslash\\hspace{0pt}}m{#1}}");
        sb.append(this.getRowSeparator());
        sb.append("\\begin{document}");
        sb.append(this.getRowSeparator());
        return sb.toString();
    }

    @Override
    public String documentEnd() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\end{document}");
        sb.append(this.getRowSeparator());
        return sb.toString();
    }
}

