/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.output;

import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.output.AbstractTextFormatter;

public final class JsonArrayFormatter
extends AbstractTextFormatter {
    private int count;
    private boolean indent;
    private static final int INDENT_SPACES = 2;

    public JsonArrayFormatter() {
        this.setUnknownCellContentCharacter("0");
        this.count = 0;
    }

    private static void appendIndent(int level, StringBuilder to) {
        assert (level >= 0);
        assert (to != null);
        int total = level * 2;
        for (int i = 0; i < total; ++i) {
            to.append(' ');
        }
    }

    @Override
    public String format(GameMatrix matrix) {
        StringBuilder sb = new StringBuilder();
        GameSchema schema = matrix.getSchema();
        if (this.count != 0) {
            sb.append(",");
            if (this.indent) {
                sb.append(this.getRowSeparator());
            }
        }
        if (this.indent) {
            JsonArrayFormatter.appendIndent(1, sb);
        }
        sb.append("[");
        if (this.indent) {
            sb.append(this.getRowSeparator());
        }
        for (int row = 0; row < schema.getWidth(); ++row) {
            if (this.indent) {
                JsonArrayFormatter.appendIndent(2, sb);
            }
            sb.append("[");
            for (int column = 0; column < schema.getWidth(); ++column) {
                byte val = matrix.get(row, column);
                String str = val == schema.getUnsetValue() ? this.getUnknownCellContentCharacter() : Integer.toString(val + 1 - schema.getMinimumValue());
                if (column != 0) {
                    if (this.indent) {
                        sb.append(", ");
                    } else {
                        sb.append(",");
                    }
                }
                sb.append(str);
            }
            sb.append("]");
            if (row != schema.getWidth() - 1) {
                sb.append(",");
            }
            if (!this.indent) continue;
            sb.append(this.getRowSeparator());
        }
        if (this.indent) {
            JsonArrayFormatter.appendIndent(1, sb);
        }
        sb.append("]");
        if (this.indent) {
            sb.append(this.getRowSeparator());
        }
        ++this.count;
        return sb.toString();
    }

    public void setIndent(boolean set) {
        this.indent = set;
    }

    @Override
    public String documentStart() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.indent) {
            sb.append(this.getRowSeparator());
        }
        this.count = 0;
        return sb.toString();
    }

    @Override
    public String documentEnd() {
        StringBuilder sb = new StringBuilder();
        sb.append("]");
        if (this.indent) {
            sb.append(this.getRowSeparator());
        }
        this.count = 0;
        return sb.toString();
    }
}

