/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.client;

import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.GameMatrixFactory;
import de.sfuhrm.sudoku.GameSchema;
import de.sfuhrm.sudoku.GameSchemas;
import de.sfuhrm.sudoku.QuadraticArrays;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.Solver;
import de.sfuhrm.sudoku.output.GameMatrixFormatter;
import de.sfuhrm.sudoku.output.JsonArrayFormatter;
import de.sfuhrm.sudoku.output.LatexTableFormatter;
import de.sfuhrm.sudoku.output.MarkdownTableFormatter;
import de.sfuhrm.sudoku.output.PlainTextFormatter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Client {
    @Option(name="-n", aliases={"-count"}, usage="The number of outputs to create")
    private int count = 1;
    @Option(name="-f", aliases={"-format"}, usage="The output format to use")
    private Formatter format = Formatter.PlainText;
    @Option(name="-e", aliases={"-exec"}, usage="The operation to perform")
    private Op op = Op.Full;
    @Option(name="-t", aliases={"-time"}, usage="Show timing information")
    private boolean timing;
    @Option(name="-q", aliases={"-quiet"}, usage="No output")
    private boolean quiet;
    @Option(name="-i", aliases={"-input"}, usage="Input file to read for solving")
    private Path input;
    @Option(name="-c", aliases={"-numberstoclear"}, usage="Amount of Numbers to clear.")
    private int maxNumbersToClear = -1;
    @Option(name="-s", aliases={"-schema"}, usage="Game matrix size for the generated game.A 9x9 sudoku has 9. There are4x4, 9x9, 16x16 and 25x25 sudokus supported.")
    private SchemaEnum schema = SchemaEnum.S9X9;
    @Option(name="-h", aliases={"-help"}, usage="Show this command line help")
    private boolean help;

    private GameSchema getSchema() {
        return this.schema.schema;
    }

    private void solve(GameMatrixFormatter formatter) throws FileNotFoundException, IOException {
        if (this.op == Op.Solve && this.input == null) {
            throw new IllegalArgumentException("Expecting input file for Solve");
        }
        List<String> lines = Files.readAllLines(this.input);
        lines = lines.stream().filter(l -> !l.isEmpty()).map(l -> l.replaceAll("[_?.]", "0")).collect(Collectors.toList());
        byte[][] data = QuadraticArrays.parse((String[])lines.toArray(new String[0]));
        GameMatrix gameMatrix = new GameMatrixFactory().newGameMatrix(this.getSchema());
        gameMatrix.setAll(data);
        Solver solver = new Solver(gameMatrix);
        List solutions = solver.solve();
        if (!this.quiet) {
            for (GameMatrix r : solutions) {
                System.out.println(formatter.format(r));
            }
        }
    }

    private void run() throws IOException {
        GameMatrixFormatter formatter = this.format.newInstance();
        long start = System.currentTimeMillis();
        if (!this.quiet) {
            System.out.print(formatter.documentStart());
        }
        if (this.op == Op.Solve) {
            this.solve(formatter);
        } else {
            block5: for (int i = 0; i < this.count; ++i) {
                switch (this.op.ordinal()) {
                    case 0: {
                        GameMatrix matrix = Creator.createFull((GameSchema)this.getSchema());
                        if (this.quiet) continue block5;
                        System.out.println(formatter.format(matrix));
                        continue block5;
                    }
                    case 1: {
                        GameMatrix matrix = Creator.createFull((GameSchema)this.getSchema());
                        Riddle riddle = this.maxNumbersToClear > 0 ? Creator.createRiddle((GameMatrix)matrix, (int)this.maxNumbersToClear) : Creator.createRiddle((GameMatrix)matrix);
                        if (this.quiet) continue block5;
                        System.out.println(formatter.format((GameMatrix)riddle));
                        continue block5;
                    }
                    case 2: {
                        GameMatrix matrix = Creator.createFull((GameSchema)this.getSchema());
                        Riddle riddle = this.maxNumbersToClear > 0 ? Creator.createRiddle((GameMatrix)matrix, (int)this.maxNumbersToClear) : Creator.createRiddle((GameMatrix)matrix);
                        if (this.quiet) continue block5;
                        System.out.println(formatter.format(matrix));
                        System.out.println(formatter.format((GameMatrix)riddle));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled case " + (Object)((Object)this.op));
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        if (!this.quiet) {
            System.out.print(formatter.documentEnd());
        }
        if (this.timing) {
            System.err.printf("Took total of %dms%n", end - start);
            System.err.printf("Each iteration took %fms%n", ((double)end - (double)start) / (double)this.count);
        }
    }

    public static void main(String[] args) throws CmdLineException, IOException {
        Client client = new Client();
        CmdLineParser parser = new CmdLineParser((Object)client);
        parser.parseArgument(args);
        if (client.help) {
            parser.printUsage((OutputStream)System.out);
            return;
        }
        client.run();
    }

    static enum Formatter {
        PlainText(PlainTextFormatter.class),
        MarkDownTable(MarkdownTableFormatter.class),
        LatexTable(LatexTableFormatter.class),
        JsonArray(JsonArrayFormatter.class);

        private final Class<? extends GameMatrixFormatter> clazz;

        private Formatter(Class<? extends GameMatrixFormatter> inClazz) {
            this.clazz = inClazz;
        }

        public GameMatrixFormatter newInstance() {
            try {
                return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    static enum Op {
        Full,
        Riddle,
        Both,
        Solve;

    }

    private static enum SchemaEnum {
        S4X4(GameSchemas.SCHEMA_4X4),
        S9X9(GameSchemas.SCHEMA_9X9),
        S16X16(GameSchemas.SCHEMA_16X16),
        S25X25(GameSchemas.SCHEMA_25X25);

        private final GameSchema schema;

        private SchemaEnum(GameSchema inSchema) {
            this.schema = inSchema;
        }
    }
}

